/* *##% Nuiton utilities library
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

/* *
 * NumberVersionUtil.java
 *
 * Created: 4 déc. 2003
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 1636 $
 *
 * Mise a jour: $Date: 2009-06-21 04:49:59 +0200 (dim., 21 juin 2009) $
 * par : $Author: tchemit $
 */

package org.nuiton.util;

/**
 *
 * @author chemit
 * @deprecated since 1.6.0, use {@link VersionUtil} instead.
 * @see Version
 * @see VersionUtil
 */
@Deprecated
public class VersionNumberUtil { // VersionNumberUtil

    protected static String normalize(String version) {
        if (version == null) {
            version = "0";
        }
        return version;
    }

    public static boolean greaterThan(String v1, String v2) {
        String[] v1s = normalize(v1).split("\\.");
        String[] v2s = normalize(v2).split("\\.");
        int minlen = Math.min(v1s.length, v2s.length);
        for (int i = 0; i < minlen; i++) {
            if (!v1s[i].equals(v2s[i]))
                return Integer.parseInt(v1s[i]) > Integer.parseInt(v2s[i]);
        }
        // si on est ici c que tout les nombres sont v1[i] = v2[i]
        return v1s.length > v2s.length;
    }

    /**
     * Regarde l'egalité entre 2 numeros de version
     * 1.2.0 et 1.2 ne sont pas egaux
     */
    public static boolean equals(String v1, String v2) {
        return normalize(v1).equals(normalize(v2));
    }

    public static boolean smallerThan(String v1, String v2) {
        String[] v1s = normalize(v1).split("\\.");
        String[] v2s = normalize(v2).split("\\.");
        int minlen = Math.min(v1s.length, v2s.length);
        for (int i = 0; i < minlen; i++) {
            if (!v1s[i].equals(v2s[i]))
                return Integer.parseInt(v1s[i]) < Integer.parseInt(v2s[i]);
        }
        // si on est ici c que tout les nombres sont v1[i] = v2[i]
        return v1s.length < v2s.length;
    }

    /**
     * Incremente le numero de version, seul le dernier constituant est
     * incremente: 1.2.3.4 -> 1.2.3.5; null -> 1; 0 -> 1
     */
    public static String inc(String v) {
        if (v == null) {
            return "1";
        } else {
            v = v.trim();
        }

        String result = null;
        int i = v.lastIndexOf('.');
        if (i == -1) {
            int n = Integer.parseInt(v) + 1;
            result = "" + n;
        } else {
            String num = v.substring(i + 1);
            int n = Integer.parseInt(num) + 1;
            result = v.substring(0, i + 1) + n;
        }
        return result;
    }

} // VersionNumberUtil

