/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.config;

import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.nuiton.util.config.AbstractApplicationConfigReport;

@Mojo(name="aggregate-config-report", aggregator=true, requiresProject=true, requiresReports=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.COMPILE)
public class AggregateApplicationConfigReport
extends AbstractApplicationConfigReport {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    protected List<?> reactorProjects;

    @Override
    protected ClassLoader createClassLoader() throws MavenReportException {
        HashSet<String> paths = new HashSet<String>();
        for (Object o : this.reactorProjects) {
            MavenProject p = (MavenProject)o;
            try {
                List runtimeClasspathElements = p.getRuntimeClasspathElements();
                paths.addAll(runtimeClasspathElements);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MavenReportException("Could not obtain dependencies for project " + p);
            }
        }
        return this.createClassLoader(paths);
    }
}

