/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.viewer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import jaxx.runtime.FileChooserUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.viewer.MatrixRenderer;
import org.nuiton.util.Resource;

public class MatrixPanelRenderer
implements ActionListener,
MatrixRenderer {
    private static Log log = LogFactory.getLog(MatrixPanelRenderer.class);
    protected JPanel panel = new JPanel(new BorderLayout());
    protected MatrixPanelEditor editor = new MatrixPanelEditor();
    protected JButton exportButton;
    protected MatrixND matrix;

    public MatrixPanelRenderer() {
        this.panel.add((Component)this.editor, "Center");
        this.exportButton = new JButton(I18n.t((String)"nuitonmatrix.viewer.renderer.exportascsv", (Object[])new Object[0]));
        this.exportButton.addActionListener(this);
        this.exportButton.setActionCommand("exportascsv");
        this.exportButton.setEnabled(false);
        this.panel.add((Component)this.exportButton, "South");
    }

    public MatrixPanelEditor getEditor() {
        return this.editor;
    }

    @Override
    public Component getComponent(MatrixND matrix) {
        this.matrix = matrix;
        this.editor.setMatrix(matrix);
        this.exportButton.setEnabled(matrix != null);
        return this.panel;
    }

    @Override
    public Icon getIcon() {
        return Resource.getIcon((String)"/icons/fatcow/table.png");
    }

    @Override
    public String getName() {
        return I18n.t((String)"nuitonmatrix.viewer.renderer.panel", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if ("exportascsv".equals(e.getActionCommand())) {
            OutputStreamWriter writer = null;
            try {
                File file = FileChooserUtil.getFile((String[])new String[]{".+\\.csv", "CSV file"});
                if (file != null) {
                    if (!file.getName().endsWith(".csv")) {
                        file = new File(file.getAbsolutePath() + ".csv");
                    }
                    writer = new FileWriter(file);
                    this.matrix.exportCSV((Writer)writer, true);
                }
            }
            catch (IOException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Error during export", (Throwable)eee);
                }
            }
            finally {
                block17: {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ex) {
                            if (!log.isErrorEnabled()) break block17;
                            log.error((Object)"Can't close writer", (Throwable)ex);
                        }
                    }
                }
            }
        }
    }
}

