/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import jaxx.runtime.validator.BeanValidatorEvent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorListener;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableMouseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwingValidatorMessageTableModel
extends AbstractTableModel
implements BeanValidatorListener {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(SwingValidatorMessageTableMouseListener.class);
    public static final String[] columnNames = new String[]{"validator.scope", "validator.field", "validator.message"};
    public static final Class<?>[] columnClasses = new Class[]{BeanValidatorScope.class, String.class, String.class};
    protected transient List<SwingValidator<?>> validators = new ArrayList();
    protected List<SwingValidatorMessage> data = new ArrayList<SwingValidatorMessage>();

    public void registerValidator(SwingValidator<?> validator) {
        if (this.validators.contains(validator)) {
            throw new IllegalArgumentException("the validator " + validator + " is already registred in " + this);
        }
        this.validators.add(validator);
        validator.addBeanValidatorListener(this);
    }

    public void addMessages(SwingValidator<?> validator, String fieldName, BeanValidatorScope scope, String ... messages) {
        this.addMessages(validator, fieldName, scope, true, messages);
    }

    public void addMessages(JComponent editor, String fieldName, BeanValidatorScope scope, String ... messages) {
        this.addMessages(editor, fieldName, scope, true, messages);
    }

    public void addMessages(SwingValidator<?> validator, BeanValidatorField<?> field, BeanValidatorScope scope, String ... messages) {
        this.addMessages(validator, field, scope, true, messages);
    }

    public void removeMessages(JComponent editor, BeanValidatorScope scope) {
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            SwingValidatorMessage error = this.data.get(i);
            if (error.getEditor() != editor || scope != null && error.getScope() != scope) continue;
            this.data.remove(i);
            this.fireTableRowsDeleted(i, i);
        }
    }

    public void removeMessages(SwingValidator<?> validator, String fieldName, BeanValidatorScope scope, String ... messages) {
        this.removeMessages(validator, fieldName, scope, true, messages);
    }

    public void removeMessages(JComponent editor, String fieldName, BeanValidatorScope scope) {
        this.removeMessages(editor, fieldName, scope, true);
    }

    public void removeMessages(SwingValidator<?> validator, BeanValidatorField<?> field, BeanValidatorScope scope, String ... messages) {
        this.removeMessages(validator, field, scope, true, messages);
    }

    public void clear() {
        int i = this.data.size();
        if (i > 0) {
            this.data.clear();
            this.fireTableRowsDeleted(0, i - 1);
        }
    }

    public SwingValidatorMessage getRow(int rowIndex) {
        this.ensureRowIndex(rowIndex);
        return this.data.get(rowIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        return columnClasses[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        this.ensureColumnIndex(column);
        return columnNames[column];
    }

    @Override
    public void onFieldChanged(BeanValidatorEvent event) {
        boolean mustDel;
        String[] toDelete = event.getMessagesToDelete();
        String[] toAdd = event.getMessagesToAdd();
        BeanValidatorField<?> field = event.getField();
        BeanValidatorScope scope = event.getScope();
        boolean mustAdd = toAdd != null && toAdd.length > 0;
        boolean bl = mustDel = toDelete != null && toDelete.length > 0;
        if (log.isTraceEnabled()) {
            log.trace((Object)"----------------------------------------------------------");
            log.trace((Object)(field + " - (" + this.getRowCount() + ") toAdd     " + mustAdd));
            log.trace((Object)(field + " - (" + this.getRowCount() + ") toDelete  " + mustDel));
        }
        SwingValidator validator = (SwingValidator)event.getSource();
        if (mustDel) {
            this.removeMessages(validator, field, scope, !mustAdd, toDelete);
        }
        if (mustAdd) {
            this.addMessages(validator, field, scope, true, toAdd);
        }
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        SwingValidatorMessage row = this.data.get(rowIndex);
        if (columnIndex == 0) {
            return row.getScope();
        }
        if (columnIndex == 1) {
            return row.getFieldName();
        }
        if (columnIndex == 2) {
            return row.getMessage();
        }
        return null;
    }

    protected void ensureRowIndex(int rowIndex) throws ArrayIndexOutOfBoundsException {
        if (rowIndex < -1 || rowIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("the rowIndex was " + rowIndex + ", but should be int [0," + (this.getRowCount() - 1) + "]");
        }
    }

    protected void ensureColumnIndex(int index) throws ArrayIndexOutOfBoundsException {
        if (index < -1 || index >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("the columnIndex was " + index + ", but should be int [0," + (this.getColumnCount() - 1) + "]");
        }
    }

    protected void addMessages(SwingValidator<?> validator, BeanValidatorField<?> field, BeanValidatorScope scope, boolean sort, String ... messages) {
        JComponent editor = validator == null ? null : validator.getFieldRepresentation(field.getName());
        for (String error : messages) {
            SwingValidatorMessage row = new SwingValidatorMessage(validator, field, error, scope, editor);
            this.data.add(row);
            if (sort) continue;
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    protected void addMessages(SwingValidator<?> validator, String fieldName, BeanValidatorScope scope, boolean sort, String ... messages) {
        JComponent editor = validator == null ? null : validator.getFieldRepresentation(fieldName);
        for (String error : messages) {
            SwingValidatorMessage row = new SwingValidatorMessage(validator, fieldName, error, scope, editor);
            this.data.add(row);
            if (sort) continue;
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    protected void addMessages(JComponent editor, String fieldName, BeanValidatorScope scope, boolean sort, String ... messages) {
        for (String error : messages) {
            SwingValidatorMessage row = new SwingValidatorMessage(null, fieldName, error, scope, editor);
            this.data.add(row);
            if (sort) continue;
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    protected void removeMessages(SwingValidator<?> validator, BeanValidatorField<?> field, BeanValidatorScope scope, boolean notify, String ... messages) {
        ArrayList<String> messagesToDel = new ArrayList<String>(Arrays.asList(messages));
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            SwingValidatorMessage error = this.data.get(i);
            if (error.getValidator() != validator || error.getScope() != scope || !error.getFieldName().equals(field.getName()) || !messagesToDel.contains(error.getMessage())) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }

    protected void removeMessages(SwingValidator<?> validator, String fieldName, BeanValidatorScope scope, boolean notify, String ... messages) {
        ArrayList<String> messagesToDel = new ArrayList<String>(Arrays.asList(messages));
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            SwingValidatorMessage error = this.data.get(i);
            if (error.getValidator() != validator || error.getScope() != scope || !error.getFieldName().equals(fieldName) || !messagesToDel.contains(error.getMessage())) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }

    protected void removeMessages(JComponent editor, String fieldName, BeanValidatorScope scope, boolean notify) {
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            SwingValidatorMessage error = this.data.get(i);
            if (error.getEditor() != editor || scope != null && error.getScope() != scope || !error.getFieldName().equals(fieldName)) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }
}

