/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;

public class JAXXRuntime {
    private static Field numReaders;
    private static Field notifyingListeners;

    public static char getFirstCharAt(String text, char defaultValue) {
        return text == null || text.trim().length() == 0 ? defaultValue : text.charAt(0);
    }

    public static <O extends Container> O getParentContainer(Object top, Class<O> clazz) {
        return (O)((Container)JAXXRuntime.getParent(top, clazz));
    }

    public static <O> O getParent(Object top, Class<O> clazz) {
        if (top == null) {
            throw new IllegalArgumentException("top parameter can not be null");
        }
        if (!Container.class.isAssignableFrom(top.getClass())) {
            throw new IllegalArgumentException("top parameter " + top + " is not a " + Container.class);
        }
        Container parent = ((Container)top).getParent();
        if (parent != null && !clazz.isAssignableFrom(parent.getClass())) {
            parent = (Container)JAXXRuntime.getParent(parent, clazz);
        }
        return (O)parent;
    }

    public static void setComponentWidth(Component component, int width) {
        component.setSize(width, component.getHeight());
        if (component instanceof JComponent) {
            JComponent jcomponent = (JComponent)component;
            jcomponent.setPreferredSize(new Dimension(width, jcomponent.getPreferredSize().height));
            jcomponent.setMinimumSize(new Dimension(width, jcomponent.getPreferredSize().height));
            if (jcomponent.isDisplayable()) {
                jcomponent.revalidate();
            }
        }
    }

    public static void setComponentHeight(Component component, int height) {
        component.setSize(component.getWidth(), height);
        if (component instanceof JComponent) {
            JComponent jcomponent = (JComponent)component;
            jcomponent.setPreferredSize(new Dimension(jcomponent.getPreferredSize().width, height));
            jcomponent.setMinimumSize(new Dimension(jcomponent.getPreferredSize().width, height));
            if (jcomponent.isDisplayable()) {
                jcomponent.revalidate();
            }
        }
    }

    public static void setText(final JTextComponent c, final String text) {
        try {
            AbstractDocument document = (AbstractDocument)c.getDocument();
            if (numReaders == null) {
                numReaders = AbstractDocument.class.getDeclaredField("numReaders");
                numReaders.setAccessible(true);
            }
            if (notifyingListeners == null) {
                notifyingListeners = AbstractDocument.class.getDeclaredField("notifyingListeners");
                notifyingListeners.setAccessible(true);
            }
            if (notifyingListeners.get(document).equals(Boolean.TRUE)) {
                return;
            }
            if ((Integer)numReaders.get(document) > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!c.getText().equals(text)) {
                            c.setText(text);
                        }
                    }
                });
                return;
            }
            String oldText = c.getText();
            if (oldText == null || !oldText.equals(text)) {
                c.setText(text);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            c.setText(text);
        }
    }

    public static String getStringValue(Object value) {
        String result = value == null ? "" : value.toString();
        return result;
    }
}

