package jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class BeanComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBO_BOX_AUTO_COMPLETE = "comboBox.autoComplete";
    public static final String BINDING_COMBO_BOX_SHOW_DECORATOR = "comboBox.showDecorator";
    public static final String BINDING_COMBO_BOX_SHOW_RESET = "comboBox.showReset";
    public static final String BINDING_SELECTED_RESULT_TEXT = "selectedResult.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28bVRCemPxynDZpQ6sCKUrTqjggrcOtKAhCEkW0MhDFOVT1hbfeabztet/y3myzkVXEn8CfAHcuSNw4IQ6cOXBB/AsIceCKmPe8XnvtdWPUHFbRvPm+9833Zsbf/QlzWsGtJyJJHBWH5HfQefDRw4efuU+wRQeoW8qPSCro/c2UoNSEipfFNcHtZt3Aaym8ti87kQwxHELv1GFJ03mAuo1IBDfziJbWtUZ2vJNEseqzZqKKWL/5+6/S195X35YAkojVlbmUjYtQg0pm61DyPYKrfNMzUQtEeMoylB+est5LJrYfCK0/FR38Ar6EhTrMR0IxGcHm9CVbDotPIoLKnQPsyCMRYrBNsG3FehxxWn0Kx8bQ85nE2UMRMrkr92RigFFkqeYJFu6cCDdAJrmRq1ifsX7HnpnMcga42pLhY/80VoJ8GVoFHDRVJinogQ2a9OUBSsQkTXkBEu7FRDIkuJZD7bex9ZT1GcRKBlzRbXl2jBqphzLhV/MpayblAFuSJUk1MW2xlRpA8E5BqalTLjuVsytfR0WhjgPKKrySP76sMeB+R+/Ypo0aUxduD7YecYu9kVPBzesMmnfQXTNNmFMxh/mFmuP9fsxHvU6/MdLphtCe/nt97bcf//jhsN/eFb77WmHq0HRy20VKRqjIN1ev9Ho7Jj+ofSKinSYPiS3Vju56gbBGeszi+L4rBu4YuPOx0G2mmFv4/aefr3/+6ytQOoSlQArvUJj8+1CmNrvcloGXRB/uWkXLZ4v8XTXaCOZdqTwWBrvdEM82TnwK0NuzsSpVN40SOwrmKe2buzJJZ2Oocze3tp4nbNt6gW2Zdrf8yz9rje93+9bNcCmvTUwf2Df3COb9MPBDtLshHfvCXVCJNMaeHIx30cBD4dxF6Rjftd+3x7wqEcwSJtyGdyebMjyYPCT9BjZQFWMSG2rHlm7+24bCWZ5eye3JSrJJn07G6GaYXsNbL9aQrZLpdBStn4u0zBIs542/1R131fF1I72/uvWcYMl/9154pPCxzztsNSuCC+hwMsGlEfWb3QJpo6TlIdvf7I54mk8uqj7bqheVPDy47/3Pwe0t3d7EjksY3slTqEibYLfbFqEXoHJOkRq5tV2tHqHkd9ja6Bc3nHOfsFOdIGVk/0/jSSDOJXsNl9/3BIkN1w89/q34YIx9xnyXLmQ04afmExQzrE6hadE8wMl5hC/gef2lldxkhv8Aq27wTTgKAAA=";
    private static final Log log = LogFactory.getLog(BeanComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autoCompleteButton;
    protected BeanComboBox<People> comboBox;
    protected JPanel configurationPanel;
    protected final BeanComboBoxDemoHandler handler = createHandler();
    protected JPanel resultPanel;
    protected JLabel selectedResult;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanComboBoxDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanComboBoxDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanComboBoxDemo() {
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanComboBoxDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutoCompleteButton() {
        return autoCompleteButton;
    }

    public BeanComboBox<People> getComboBox() {
        return comboBox;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public BeanComboBoxDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JLabel getSelectedResult() {
        return selectedResult;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(autoCompleteButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
    }

    protected void addChildrenToResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        resultPanel.add(selectedResult, BorderLayout.CENTER);
    }

    protected void createAutoCompleteButton() {
        $objectMap.put("autoCompleteButton", autoCompleteButton = new JCheckBox());
        
        autoCompleteButton.setName("autoCompleteButton");
        autoCompleteButton.setText(t("jaxxdemo.beancomboboxdemo.autoComplete"));
        autoCompleteButton.setSelected(true);
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new BeanComboBox<People>());
        
        comboBox.setName("comboBox");
        comboBox.setI18nPrefix("jaxxdemo.common.");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected BeanComboBoxDemoHandler createHandler() {
        return new BeanComboBoxDemoHandler();
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedResult() {
        $objectMap.put("selectedResult", selectedResult = new JLabel());
        
        selectedResult.setName("selectedResult");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(t("jaxxdemo.beancomboboxdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.beancomboboxdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigurationPanel();
        addChildrenToResultPanel();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        comboBox.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(t("jaxxdemo.beancomboboxdemo.configuration")));
        resultPanel.setBorder(new TitledBorder(t("jaxxdemo.beancomboboxdemo.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createAutoCompleteButton();
        createShowResetButton();
        createShowDecoratorButton();
        createComboBox();
        createResultPanel();
        createSelectedResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_AUTO_COMPLETE, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoCompleteButton != null) {
                    $bindingSources.put("autoCompleteButton.getModel()", autoCompleteButton.getModel());
                    autoCompleteButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    autoCompleteButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_AUTO_COMPLETE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoCompleteButton != null) {
                    comboBox.setAutoComplete(autoCompleteButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoCompleteButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoCompleteButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    autoCompleteButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_AUTO_COMPLETE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    comboBox.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    comboBox.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_RESULT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (comboBox != null) {
                    comboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (comboBox != null && handler != null) {
                    selectedResult.setText(t(handler.getSelectedResult((People) comboBox.getSelectedItem())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (comboBox != null) {
                    comboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

}
