package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class JCheckBoxMenuItemDemo extends JMenuItemDemo {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENTS_EDITABLE = "comments.editable";
    public static final String BINDING_COMMENTS_ENABLED = "comments.enabled";
    public static final String BINDING_EMAIL_EDITABLE = "email.editable";
    public static final String BINDING_EMAIL_ENABLED = "email.enabled";
    public static final String BINDING_FIRST_NAME_EDITABLE = "firstName.editable";
    public static final String BINDING_FIRST_NAME_ENABLED = "firstName.enabled";
    public static final String BINDING_LAST_NAME_EDITABLE = "lastName.editable";
    public static final String BINDING_LAST_NAME_ENABLED = "lastName.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzW8SURAfsNBvqf02rZHWJmqiix8n06ptqcQiaCM9NHLxwb6W1y67z7cPu43R+Cf4J+jdi4k3T8aDZw9ejP+CMR68GuctLLB0CySQsCnz5veb38ybme37XxCxBSzsE8fRRMWUrEy19NrOzqPCPi3KDWoXBePSElD9hMIQzsOwXrfbEi7kMwqeqMETSavMLZOaTejlDAzZ8sigdolSKeGcH1G07USufrzs8IrwWOuigljf/vkdfqO/fhcGcDiqi2Eq8U6oRiZ9GQgzXcI4RnpOEgYx91CGYOYe6h1VtqRBbPshKdNn8Ar6MxDlRCCZhMXuU3Y5XLzDJcSW0llqVjYlLW/QsnVNQsIVrOMPrejRaPYhqtDSyRItHqxbTjOEc5ctKqG/jOZ1IiRMKrGOh8pWzU2O1aAY7MwxR+UyUveMUZMUDKp7gfGqfIhWQQoWq6PHqM6kwntuyj7p9xnaFVjPLWJSQ8Ks77KqMbYVQUP7wFI6QwrUQPHjPimuVTnN1H0Hdxk2pLovCdM+523qyBSjhu4CJPTtWqLcGuK6+j3vpxzA25NeB5xvh74RgI7QMmFGR+jNAOjoUjpXFJZhqFJh8jO+fBpHLXKxhbArJI7l1LECrAlKlN9VT4aAOd8F4BxqjTlsDEooDxFRQTPeWP746D7Go+rQzrYMrSJ0T/9NT3z/9PNjypvUSYw9FejatGhwgriwOBWSqdCx6phWJDMSWcKX8zBoUwO3lLuF5gOE5WrHKA7jub2vKbh2n9glpIj0//j8Zfrpt1MQTsGQYRE9RZT/JgzKksAqWIbu8LurrqKRwwF8juE3jHX2Ol3Cwot4a9trzK6Gpvqly/GXOIC1sZIQR2//iLU4O1jG+YAy1nMpDH79O5H7sOqVMoSpnT3RvVHOyBOIMtNgJnXXXm2jBa65YW7Tim41NlfQLgPOeXM/33Kft49VK4ROErsP53elGj9OJG7ZQkXSO467f5JuGuqveyH1HOO1+W/DOWDXiqY8HgTzTHTkUeZ0zwxbbRime9bQmcFdU7hHUha+C06v6ESSeIGZOk7+CRWe61lVZwZ82+jM5gY5onrWxDeXyYo9ESqzu8AKwQyLPSfVHcNBzwztsrjYcxbdMbTLojuGdllc6TmL7hjaZdGZQUK0RNleSbZh0bpgiRzi/5GlDiT/AfrKOytsCwAA";
    private static final Log log = LogFactory.getLog(JCheckBoxMenuItemDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextArea comments;
    protected JCheckBoxMenuItem editableCheckBox;
    protected JTextField email;
    protected JCheckBoxMenuItem enabledCheckBox;
    protected JTextField firstName;
    protected JTextField lastName;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JMenu $JMenu0;
    private JCheckBoxMenuItemDemo $JMenuItemDemo0 = this;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBoxMenuItemDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JCheckBoxMenuItemDemo() {
        $initialize();
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextArea getComments() {
        return comments;
    }

    public JCheckBoxMenuItem getEditableCheckBox() {
        return editableCheckBox;
    }

    public JTextField getEmail() {
        return email;
    }

    public JCheckBoxMenuItem getEnabledCheckBox() {
        return enabledCheckBox;
    }

    public JTextField getFirstName() {
        return firstName;
    }

    @Override
    public Table getFramePanel() {
        return (Table) super.getFramePanel();
    }

    public JTextField getLastName() {
        return lastName;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFramePanel() {
        if (!allComponentsCreated) {
            return;
        }
        framePanel.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add(firstName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add(lastName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add(email, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JScrollPane0, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMenuBar() {
        if (!allComponentsCreated) {
            return;
        }
        menuBar.add($JMenu0);
    }

    protected void createComments() {
        $objectMap.put("comments", comments = new JTextArea());
        
        comments.setName("comments");
        comments.setColumns(15);
        comments.setLineWrap(true);
        comments.setWrapStyleWord(true);
    }

    protected void createEditableCheckBox() {
        $objectMap.put("editableCheckBox", editableCheckBox = new JCheckBoxMenuItem());
        
        editableCheckBox.setName("editableCheckBox");
        editableCheckBox.setSelected(true);
        editableCheckBox.setText(t("Editable"));
    }

    protected void createEmail() {
        $objectMap.put("email", email = new JTextField());
        
        email.setName("email");
        email.setColumns(15);
    }

    protected void createEnabledCheckBox() {
        $objectMap.put("enabledCheckBox", enabledCheckBox = new JCheckBoxMenuItem());
        
        enabledCheckBox.setName("enabledCheckBox");
        enabledCheckBox.setSelected(true);
        enabledCheckBox.setText(t("Enabled"));
    }

    protected void createFirstName() {
        $objectMap.put("firstName", firstName = new JTextField());
        
        firstName.setName("firstName");
        firstName.setColumns(15);
    }

    @Override
    protected void createFramePanel() {
        super.createFramePanel();
        framePanel.setName("framePanel");
    }

    protected void createLastName() {
        $objectMap.put("lastName", lastName = new JTextField());
        
        lastName.setName("lastName");
        lastName.setColumns(15);
    }

    @Override
    protected void createMenuBar() {
        super.createMenuBar();
        menuBar.setName("menuBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMenuBar();
        // inline complete setup of $JMenu0
        $JMenu0.add(enabledCheckBox);
        $JMenu0.add(editableCheckBox);
        addChildrenToFramePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(comments);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $JLabel0.setLabelFor(firstName);
        $JLabel1.setLabelFor(lastName);
        $JLabel2.setLabelFor(email);
        $JLabel3.setLabelFor(comments);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JMenuItemDemo0", $JMenuItemDemo0);
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("View"));
        createEnabledCheckBox();
        createEditableCheckBox();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("First Name:"));
        $JLabel0.setDisplayedMnemonic(70);
        createFirstName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("Last Name:"));
        $JLabel1.setDisplayedMnemonic(76);
        createLastName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("Email Address:"));
        $JLabel2.setDisplayedMnemonic(69);
        createEmail();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("Comments:"));
        $JLabel3.setDisplayedMnemonic(67);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        SwingUtil.setComponentHeight($JScrollPane0,75);
        SwingUtil.setComponentWidth($JScrollPane0,150);
        createComments();
        // inline creation of $JMenuItemDemo0
        setName("$JMenuItemDemo0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_NAME_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    firstName.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_EDITABLE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_NAME_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    firstName.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_ENABLED));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_NAME_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    lastName.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_EDITABLE));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_NAME_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    lastName.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_ENABLED));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    email.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_EDITABLE));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    email.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_ENABLED));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENTS_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    comments.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_EDITABLE));
                }
            }
        
            public void $pr$u6(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENTS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    comments.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_ENABLED));
                }
            }
        
            public void $pr$u7(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}