package jaxx.demo.component.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.datetime.TimeEditor;

public class TimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdO9iJ7UASRwkBgpSEdKBzBAghhY8QBwsiBxBxEeGGtW+xL6x3l9s9cmkQP4GfAD0NEh0VoqCmoEH8BYQoaBGza/sulxgFgYv13cy8NzNvb+b1N8goH+a3SRg6fsC116HO+o2trbuNbdrUa1Q1fU9q4UP3l0pDug4FN7IrDWfqVQMv9eClsuhIwSnfg16uQl7pXUZVm1Kt4XQS0VSqtBm5l0MZ+H3WqKhBrC9/fE+/cJ+/SgOEEqsrYCtzh6HiTo5UIe25GoqY6SkpMcJbWIbv8RbWe9TYyowodYd06BN4BsNVyEriI5mGhb9v2XJYfCg1FBbXaEfcI5yyJQ2XbbEuWpxmn8Kxth3PbVGtHJdoajup4XHT9ZDZEEhpKbMaMh3hUqbh6r9SbRh8zDeyuN6vrmgkCB21g4o4XasJykWxhabgj7yW9WiYSSjfRdVIg1nxxiLQOCMNysoWWTWP+xNZowkuxon2YDRMJ8JrNNQVjzI3CRml3OReDbQWXMNUAlNu0+bjVREmIVlqRdFwVvgthwf4wg+VMNlc1qcqYNq8TSS1Gut6DDBq8Lg55qOQfBxiLCd7Xh9OJZTFaXHiaYk/51QdMn6AZryK+sEBu4+u7mjN7BstQ2i9v6YnP7/7+rbSn6chzD01MHTPOsDvXPpCUl97JvVYd5gC7bHSBpHLdcgpynCX2F0xO6CwzZ4bi8N8EwbuGLhzi6g2UmSGv7z/MP3w0xCkK5BngrgVYuJvQ063UbK2YG4or6/YikZ3RvAcN7XhbTCyK/ADgGNX8ObIXMPjLt7/tRBFmB0gQlRJI/fx5+Tmm5W+ECks7MQfw2MxMg8g63HmcWpXS29rDFwlBalo4Ip4OwzaFynzn5e96Txnz6WDnRrzeXNcCAPzd9GWbJ4uWd/4fzMsIMNvDpB4vSwGAAA=";
    private static final Log log = LogFactory.getLog(TimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table configPanel;
    protected TimeEditor editor;
    protected JCheckBox enableButton;
    protected final TimeEditorDemoHandler handler = createHandler();
    protected JTextField labelConfig;
    protected JLabel labelConfigLabel;
    protected TimeEditorDemoModel model;
    protected JPanel result;
    protected JTextField resultTime;
    protected JLabel resultTimeLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TimeEditorDemo $DemoPanel0 = this;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditorDemo() {
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getConfigPanel() {
        return configPanel;
    }

    public TimeEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public TimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JTextField getLabelConfig() {
        return labelConfig;
    }

    public JLabel getLabelConfigLabel() {
        return labelConfigLabel;
    }

    public TimeEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JTextField getResultTime() {
        return resultTime;
    }

    public JLabel getResultTimeLabel() {
        return resultTimeLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configPanel.add(labelConfigLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(labelConfig, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(enableButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultTimeLabel);
        result.add(resultTime);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new Table());
        
        configPanel.setName("configPanel");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new TimeEditor(this));
        
        editor.setName("editor");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
    }

    protected TimeEditorDemoHandler createHandler() {
        return new TimeEditorDemoHandler();
    }

    protected void createLabelConfig() {
        $objectMap.put("labelConfig", labelConfig = new JTextField());
        
        labelConfig.setName("labelConfig");
        labelConfig.setColumns(15);
    }

    protected void createLabelConfigLabel() {
        $objectMap.put("labelConfigLabel", labelConfigLabel = new JLabel());
        
        labelConfigLabel.setName("labelConfigLabel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TimeEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,2));
    }

    protected void createResultTime() {
        $objectMap.put("resultTime", resultTime = new JTextField());
        
        resultTime.setName("resultTime");
        resultTime.setColumns(15);
    }

    protected void createResultTimeLabel() {
        $objectMap.put("resultTimeLabel", resultTimeLabel = new JLabel());
        
        resultTimeLabel.setName("resultTimeLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($JPanel0, BorderLayout.NORTH);
        add(result, BorderLayout.CENTER);
        // inline complete setup of $JPanel0
        $JPanel0.add(configPanel, BorderLayout.NORTH);
        $JPanel0.add(editor, BorderLayout.CENTER);
        addChildrenToConfigPanel();
        addChildrenToResult();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigPanel();
        createLabelConfigLabel();
        createLabelConfig();
        createEnableButton();
        createEditor();
        createResult();
        createResultTimeLabel();
        createResultTime();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}