/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.Timer;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JProgressBarDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_FOREGROUND = "$JLabel0.foreground";
    private static final String BINDING_$JPROGRESS_BAR0_FOREGROUND = "$JProgressBar0.foreground";
    private static final String BINDING_$JPROGRESS_BAR0_VALUE = "$JProgressBar0.value";
    private static final String BINDING_$JPROGRESS_BAR1_FOREGROUND = "$JProgressBar1.foreground";
    private static final String BINDING_$JPROGRESS_BAR1_VALUE = "$JProgressBar1.value";
    private static final String BINDING_$JPROGRESS_BAR2_FOREGROUND = "$JProgressBar2.foreground";
    private static final String BINDING_$JPROGRESS_BAR2_VALUE = "$JProgressBar2.value";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS2/TQBDehCZpUmghEVURRWohIB7CKeVV1KotbVXRECAQDlVzgE28TVz5xe66dTkgfgI/Ae5ckLhxQhw4c+CC+AsIceCKmF3n2bp21PhgWzPffPPNrGf8/heKMYomt7DrKtQxuWYQJX93ff1RZYtU+QphVarZ3KLIuyJRFC2jIbVlZxydKxdEeK4Rnlu2DNsyidkRPVtAKcZ3dcLqhHCOznRHVBnLlVruWdd2aJO1JcqP9e2f39E36ut3UYRcG9SloZSJsKh2JQMFFNVUjtKQaRvndGzWQAbVzBroPSZsyzpm7CE2yAv0CiUKKG5jCmQcne29ZMkh412bo6HsCjGsIjaJPsXRZSlWBYtSbVIobAcUKPkitWqUMLaEqQixbUkS5yiTLckca6bGNaxrLwkFqguSSrBoOqGKJ0PZhwykuSZcw4GQ6XDI9XDIjXDIzXDIrXDI7XDITDjkzh5IIvsUV3QCXR/r+tq8k5M+gUy2Agaz+QKuyCNPi+/KbR6ytArQZAs7nO08ei9HR0SHLyhOHuWlIMS0DyKZzS85nFsmpM10pfXMB6BlsqmGk6LTXU2B4Vbaw92evkgZxagDZqiwvH8fPAGXtwnG9mwCQSi9/0Yz3z/9/LjaHP8RyH3SF9qxvWAsbWrZhHJNpB7xZt/hmp57gO3ZMkoyosPqk6tt3EdYqeEGcZDvhAhXRLhyD7M6UMQSPz5/GX3+7QiKrqKUbmF1FQv8GkryOvS+bumqay8sSkVHdwbhflxo4yiu410LGoqG51TM8URFM1Vo/rwLTRj3aUJLSSX59W+m9GGx2YgICDt1ILzdjNgGimumrplEbsLGkvPdfEM2I45qtZeZ33qLiGfKbgzKjLzP+VU6sGmZXHgXXEc8FqVo8bYkOc73wJHatCipUcsx1T6ZBjhxoevpOa8XE5jDT6DicDJ/WE5hvh+g6mIPqhIGdjXDMQTg8eFpYttYd0hfWsKqudITw0ZAIb0xPOtbQ1AVV/uuojeGoCp6YygGaMj1zTANDP8Bybzv1hcKAAA=";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JProgressBarDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JProgressBarDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JProgressBar $JProgressBar0;
    private javax.swing.JProgressBar $JProgressBar1;
    private javax.swing.JProgressBar $JProgressBar2;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    int red;
    int green;
    int blue;
    int speed;
    int redDirection;
    int greenDirection;
    int blueDirection;
    Timer redTimer;
    Timer greenTimer;
    Timer blueTimer;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JProgressBarDemo() {
        super();
        $initialize();
    }

    public JProgressBarDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        redTimer.start(); greenTimer.start(); blueTimer.start();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        redTimer.stop(); greenTimer.stop(); blueTimer.stop();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JProgressBar get$JProgressBar0() {
        return $JProgressBar0;
    }

    protected javax.swing.JProgressBar get$JProgressBar1() {
        return $JProgressBar1;
    }

    protected javax.swing.JProgressBar get$JProgressBar2() {
        return $JProgressBar2;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add($JProgressBar0, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add($JProgressBar1, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add($JProgressBar2, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        $JLabel0.setFont(UIManager.getFont("Label.font").deriveFont(18f));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        red = 0;
        green = 0;
        blue = 0;
        speed = 2;
        redDirection = 1;
        greenDirection = 1;
        blueDirection = 1;
        redTimer = new Timer(5, new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    jaxx.runtime.JAXXUtil.assignment(red = Math.max(0, Math.min(255, red + speed * redDirection)), "red", jaxx.demo.component.swing.JProgressBarDemo.this);
                    if (red == 0 || red == 255)
                        jaxx.runtime.JAXXUtil.assignment(redDirection = -redDirection, "redDirection", jaxx.demo.component.swing.JProgressBarDemo.this);
                }
            });
        greenTimer = new Timer(50, new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    jaxx.runtime.JAXXUtil.assignment(green = Math.max(0, Math.min(255, green + speed * greenDirection)), "green", jaxx.demo.component.swing.JProgressBarDemo.this);
                    if (green == 0 || green == 255)
                        jaxx.runtime.JAXXUtil.assignment(greenDirection = -greenDirection, "greenDirection", jaxx.demo.component.swing.JProgressBarDemo.this);
                }
            });
        blueTimer = new Timer(500, new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    jaxx.runtime.JAXXUtil.assignment(blue = Math.max(0, Math.min(255, blue + speed * blueDirection)), "blue", jaxx.demo.component.swing.JProgressBarDemo.this);
                    if (blue == 0 || blue == 255)
                        jaxx.runtime.JAXXUtil.assignment(blueDirection = -blueDirection, "blueDirection", jaxx.demo.component.swing.JProgressBarDemo.this);
                }
            });
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("Welcome to the JAXX framework!"));
        // inline creation of $JProgressBar0
        $objectMap.put("$JProgressBar0", $JProgressBar0 = new javax.swing.JProgressBar());
        
        $JProgressBar0.setName("$JProgressBar0");
        $JProgressBar0.setMaximum(255);
        // inline creation of $JProgressBar1
        $objectMap.put("$JProgressBar1", $JProgressBar1 = new javax.swing.JProgressBar());
        
        $JProgressBar1.setName("$JProgressBar1");
        $JProgressBar1.setMaximum(255);
        // inline creation of $JProgressBar2
        $objectMap.put("$JProgressBar2", $JProgressBar2 = new javax.swing.JProgressBar());
        
        $JProgressBar2.setName("$JProgressBar2");
        $JProgressBar2.setMaximum(255);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("Start"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("Stop"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        redTimer.start();greenTimer.start();blueTimer.start();// registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_FOREGROUND, true ,"red" ,"green" ,"blue") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setForeground(new Color(red, green, blue));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR0_FOREGROUND, true ,"red") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar0.setForeground(new Color(red, 0, 0));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR0_VALUE, true ,"red") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar0.setValue(red);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR1_FOREGROUND, true ,"green") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar1.setForeground(new Color(0, green, 0));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR1_VALUE, true ,"green") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar1.setValue(green);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR2_FOREGROUND, true ,"blue") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar2.setForeground(new Color(0, 0, blue));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JPROGRESS_BAR2_VALUE, true ,"blue") {
        
            @Override
            public void processDataBinding() {
                $JProgressBar2.setValue(blue);
            }
        });
    }

}