/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: DemoConfig.java 2015 2010-06-30 17:49:34Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2/jaxx-demo/src/main/java/jaxx/demo/DemoConfig.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.demo;

import jaxx.demo.feature.nav.NavDemo;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

import static org.nuiton.i18n.I18n._;

/**
 * La configuration de l'application.
 * <p/>
 * Il s'agit de l'objet partagé par toutes les démos.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.7.2
 */
public class DemoConfig extends ApplicationConfig {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(DemoConfig.class);

    /**
     * le fichier de configuration de l'application avec les informations sur
     * le projet (version, license,...) et la configuration des ui (icons, ...)
     */
    public static final String APPLICATION_PROPERTIES = "/jaxx-demo.properties";

    public static final String PROPERTY_FULLSCREEN = "fullscreen";

    public static final String PROPERTY_LOCALE = "locale";

    public static final String PROPERTY_FONT_SIZE = "fontSize";

    public DemoConfig() {

        setConfigFileName(Option.CONFIG_FILE.defaultValue);

        // chargement de la configuration interne

        InputStream stream =
                getClass().getResourceAsStream(APPLICATION_PROPERTIES);

        Properties p = new Properties();
        try {
            p.load(stream);
            for (Object k : p.keySet()) {
                String key = k + "";
                Object value = p.get(k);
                if (log.isDebugEnabled()) {
                    log.debug("install properties " + k + " : " + value);
                }
                setDefaultOption(key, "" + value);
            }
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }

        for (Option o : Option.values()) {
            setDefaultOption(o.key, o.defaultValue);
        }

        // on supprime le stamp de snapshot s'il existe
        String sVersion = VersionUtil.removeSnapshot(
                getOption("application.version"));
        Version version = VersionUtil.valueOf(sVersion);
        setDefaultOption("version", version.getVersion());

        installSaveUserAction(PROPERTY_FULLSCREEN,
                              PROPERTY_FONT_SIZE,
                              PROPERTY_LOCALE);
    }

    public String getCopyrightText() {
        return "Version " + getVersion() + " Codelutin @ 2008-2009";
    }

    /** @return la version de l'application. */
    public Version getVersion() {
        Version option = getOption(Version.class, "version");
        return option;
    }

    public boolean isFullScreen() {
        Boolean result = getOptionAsBoolean(Option.FULL_SCREEN.key);
        return result != null && result;
    }

    public Locale getLocale() {
        Locale result = getOption(Locale.class, Option.LOCALE.key);
        return result;
    }

    public String getDemoPath() {
        String result = getOption(Option.DEMO_PATH.key);
        return result;
    }

    public Float getFontSize() {
        Float result = getOption(Float.class, Option.FONT_SIZE.key);
        return result;
    }

    public void setFullscreen(boolean fullscreen) {
        Object oldValue = null;
        setOption(Option.FULL_SCREEN.key, fullscreen + "");
        firePropertyChange(PROPERTY_FULLSCREEN, oldValue, fullscreen);
    }

    public void setLocale(Locale newLocale) {
        setOption(Option.LOCALE.key, newLocale.toString());
        firePropertyChange(PROPERTY_LOCALE, null, newLocale);
    }

    public void setFontSize(Float newFontSize) {
        Float oldValue = getFontSize();
        if (log.isDebugEnabled()) {
            log.debug("changing font-size to " + newFontSize);
        }
        setOption(Option.FONT_SIZE.key, newFontSize.toString());
        firePropertyChange(PROPERTY_FONT_SIZE, oldValue, newFontSize);
    }

    /**
     * Save configuration, in user home directory using the
     * {@link #getConfigFileName}. Default, env and commande line note saved
     */
    public void saveForUser() {
        // shoudl we never save any conf ?
        super.saveForUser();
    }

    public static final String[] DEFAULT_JAXX_PCS = {
            PROPERTY_FULLSCREEN,
            PROPERTY_LOCALE,
            PROPERTY_FONT_SIZE,
            ADJUSTING_PROPERTY
    };

    public void removeJaxxPropertyChangeListener() {
        PropertyChangeListener[] toRemove;
        toRemove = JAXXUtil.findJaxxPropertyChangeListener(
                DEFAULT_JAXX_PCS,
                getPropertyChangeListeners());
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("before remove : " + getPropertyChangeListeners().length);
            log.debug("toRemove : " + toRemove.length);
        }
        for (PropertyChangeListener listener : toRemove) {
            removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug("after remove : " + getPropertyChangeListeners().length);
        }
    }

    //////////////////////////////////////////////////
    // Toutes les options disponibles
    //////////////////////////////////////////////////

    public enum Option implements OptionDef {

        CONFIG_FILE(
                CONFIG_FILE_NAME,
                _("jaxxdemo.config.configFileName.description"),
                "jaxxdemo",
                String.class,
                true,
                true),
        FULL_SCREEN(
                "ui.fullscreen",
                _("jaxxdemo.config.ui.fullscreen"),
                "false",
                Boolean.class,
                false,
                false),
        LOCALE(
                "ui." + PROPERTY_LOCALE,
                _("jaxxdemo.config.ui.locale"),
                Locale.FRANCE.toString(),
                Locale.class,
                false,
                false),
        FONT_SIZE(
                "ui." + PROPERTY_FONT_SIZE,
                _("jaxxdemo.config.ui.fontSize"),
                "10f",
                Float.class,
                false,
                false),
        DEMO_PATH(
                "ui.demo.path",
                _("jaxxdemo.config.ui.demo.path"),
                "jaxxdemo.tree/jaxxdemo.tree.component.jaxx/jaxxdemo.tree.component.jaxx.tree/" + NavDemo.class.getSimpleName(),
                String.class,
                false,
                true);

        public final String key;

        public final String description;

        public String defaultValue;

        public final Class<?> type;

        public boolean _transient;

        public boolean _final;

        Option(String key,
               String description,
               String defaultValue,
               Class<?> type,
               boolean _transient,
               boolean _final) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this._final = _final;
            this._transient = _transient;
        }

        @Override
        public boolean isFinal() {
            return _final;
        }

        @Override
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public void setTransient(boolean _transient) {
            this._transient = _transient;
        }

        @Override
        public void setFinal(boolean _final) {
            this._final = _final;
        }

        @Override
        public boolean isTransient() {
            return _transient;
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public String getDescription() {
            return description;
        }

        @Override
        public String getKey() {
            return key;
        }

        @Override
        public Class<?> getType() {
            return type;
        }


    }
}
