/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JSpinnerDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$VBOX0_SPACING = "$VBox0.spacing";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1TPW8TQRAdm9iOYxISG4yBIBmwAFGc+SgdQSCRBZYDCEsowg3ru1W80d3ecrtHLg3iJ/AToKdBoqNCFNQUNIi/gBAFLWL2/HnkcCyCi7W9896bN7Mzr79BSnpwZpsEgeH5XDGHGo2bm5v3OtvUVOtUmh4TyvWg90kkIdmGnDW8lwrOtZuaXu3Tq2uuI1xO+Ri71oQ5qXZtKruUKgWnowxTymprGK4FwvcGqkNTcaovf3xPvrCev0oCBALdZbCU8n6sUSUzTUgyS0EeMz0lVZvwLbThMb6Ffuf13ZpNpLxLHPoEnkGmCWlBPBRTcHb6kkONkB8IBbnKOnXc+4RT+7KC86FZC28McyBhyB10YDRagnFOPQ0XIhRIK5itNJqkE3Lz2mAwQIe3GpQdYjOyp6DgaATaF46C05WHt9wAZY9H+tej6FAUPvBxRf9f0Ed+T+zqhNi18ZgHpyJJcRyM0TiM3ivRhpTn47WCUnvvBD3AUG92Sn/MjhYMo7+Khc/vvr6tDwYmi7mPxULH5h0fUniuwEYynfpIb1p8xezqBhG1NqpQG5clXIblGGOtfhjNYb4lTTc03bhNZBclUpkv7z8UH386BMk6zNkusepE4+9AVnU97IJrW4G4sRo6Orwzi+ei9obttHUz6y6+8cKKRRQpdxi38MmuB9iG5Zg2DL10sh9/FlpvVgetSKC1E3+Fj9qRegRpxm3Gabg9/cWI3ZackNS33NECxK1EQn/Pi/6Il8OzElfrjKIBbl5+pZe9TBSuasdXFGvVpIthEfrXpak1lywmhU12qbXBcc84MzW0+u+CGYcEzPGdCTKLU8kw/j9kpCAmToMGXIiXKewro6+NCUaKB1YoHVjhJCr8BjAuaO/LBgAA";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JSpinnerDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSpinner spinner;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSpinnerDemo $DemoPanel0 = this;
    private javax.swing.JLabel $JLabel0;
    private jaxx.runtime.swing.VBox $VBox0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JSpinnerDemo() {
        super();
        $initialize();
    }

    public JSpinnerDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JSpinner getSpinner() {
        return spinner;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createSpinner() {
        $objectMap.put("spinner", spinner = new javax.swing.JSpinner(new SpinnerNumberModel(0, 0, 50, 1)));
        
        spinner.setName("spinner");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($JLabel0);
        add(spinner);
        add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($JLabel1);
        $VBox0.add($JLabel2);
        $VBox0.add($JLabel3);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JLabel0.setLabelFor(spinner);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("Spacing:"));
        $JLabel0.setDisplayedMnemonic(83);
        createSpinner();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        
        $VBox0.setName("$VBox0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("Use the spinner to"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("adjust the spacing"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("between these lines"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$VBOX0_SPACING, true) {
        
            @Override
            public void applyDataBinding() {
                if (spinner != null) {
                    $bindingSources.put("spinner.getModel()", spinner.getModel());
                    spinner.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    spinner.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSpinnerDemo.this, BINDING_$VBOX0_SPACING));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (spinner != null && spinner.getValue() != null) {
                    $VBox0.setSpacing(((Integer) spinner.getValue()).intValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (spinner != null) {
                    javax.swing.SpinnerModel $target = ((javax.swing.SpinnerModel) $bindingSources.remove("spinner.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    spinner.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSpinnerDemo.this, BINDING_$VBOX0_SPACING));
                }
            }
        
            public void $pr$u0(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
    }

}