/*
 * *##% 
 * JAXX Demo
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.demo.component.jaxx.editor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/**
 *
 * @author chemit
 * @since 1.5
 */
public class NumberEditorDemoModel {

    public static final String INTEGER_PROPERTY = "integerProperty";
    public static final String FLOAT_PROPERTY = "floatProperty";
    protected PropertyChangeSupport p;
    protected int integerProperty;
    protected float floatProperty;

//    protected int positifInteger;
//    protected int normalInteger;
//    protected float positifFloat;
//    protected float normalFloat;
    public NumberEditorDemoModel() {
        p = new PropertyChangeSupport(this);
    }

    public float getFloatProperty() {
        return floatProperty;
    }

    public int getIntegerProperty() {
        return integerProperty;
    }

    public void setFloatProperty(float floatProperty) {
        float old = this.floatProperty;
        this.floatProperty = floatProperty;
        p.firePropertyChange(FLOAT_PROPERTY, old, floatProperty);
    }

    public void setIntegerProperty(int integerProperty) {
        int old = this.integerProperty;
        this.integerProperty = integerProperty;
        p.firePropertyChange(INTEGER_PROPERTY, old, integerProperty);
    }

//
//    public float getNormalFloat() {
//        return normalFloat;
//    }
//
//    public int getNormalInteger() {
//        return normalInteger;
//    }
//
//    public float getPositifFloat() {
//        return positifFloat;
//    }
//
//    public int getPositifInteger() {
//        return positifInteger;
//    }
//
//    public void setNormalFloat(float normalFloat) {
//        float old = this.normalFloat;
//        this.normalFloat = normalFloat;
//        p.firePropertyChange("normalFloat", old, normalFloat);
//    }
//
//    public void setNormalInteger(int normalInteger) {
//        int old = this.normalInteger;
//        this.normalInteger = normalInteger;
//        p.firePropertyChange("normalInteger", old, normalInteger);
//    }
//
//    public void setPositifFloat(float positifFloat) {
//        float old = this.positifFloat;
//        this.positifFloat = positifFloat;
//        p.firePropertyChange("positifFloat", old, positifFloat);
//    }
//
//    public void setPositifInteger(int positifInteger) {
//        int old = this.positifInteger;
//        this.positifInteger = positifInteger;
//        p.firePropertyChange("positifInteger", old, positifInteger);
//    }
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }
}
