package jaxx.compiler.binding;

import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.finalizers.DefaultFinalizer;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.runtime.JAXXBinding;

import java.util.List;

/**
 * Created: 5 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 1679 $
 *          <p/>
 *          Mise a jour: $Date: 2009-12-08 18:21:03 +0100 (mar., 08 déc. 2009) $ par :
 *          $Author: tchemit $
 */
public abstract class AbstractJAXXBindingWriter<B extends JAXXBinding> implements JAXXBindingWriter<B> {

    private final Class<B> type;
    protected boolean used;

    protected AbstractJAXXBindingWriter(Class<B> type) {
        this.type = type;
    }

    @Override
    public boolean isUsed() {
        return used;
    }


    public Class<B> getType() {
        return type;
    }

    protected abstract String getConstructorParams(DataBinding binding, DataListener[] trackers);

    protected void writeInvocationMethod(DataBinding binding, DataListener[] trackers, JavaFileGenerator generator, StringBuilder buffer, List<JavaMethod> bMethods) {
        used = true;
        String eol = JAXXCompiler.getLineSeparator();
        buffer.append(DefaultFinalizer.METHOD_NAME_REGISTER_DATA_BINDING + "(new ");
        buffer.append(getType().getSimpleName()).append("(").append(getConstructorParams(binding, trackers)).append(") {").append(eol);
        for (JavaMethod m : bMethods) {
            buffer.append(eol).append(JavaFileGenerator.indent(generator.generateMethod(m), 4, false, eol)).append(eol);
        }
        buffer.append("});").append(eol);

        if (binding.getInitDataBinding() != null) {
            buffer.append(binding.getInitDataBinding());
        }
    }
}