package org.nuiton.jaxx.application.swing.table;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JTable;
import java.awt.event.ActionEvent;

/**
 * Action to select next editable row in a table.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public class MoveToNextEditableRowAction<M extends AbstractApplicationTableModel> extends AbstractSelectTableAction<M> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(MoveToNextEditableRowAction.class);

    public static <M extends AbstractApplicationTableModel> MoveToNextEditableRowAction<M> newAction(M model, JTable table) {
        return new MoveToNextEditableRowAction<M>(model, table);
    }

    protected MoveToNextEditableRowAction(M model, JTable table) {
        super(model, table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int currentRow = getSelectedRow();
        int currentColumn = getSelectedColumn();

        if (log.isDebugEnabled()) {
            log.debug("Move to next row editable cell " +
                      getCellCoordinate(currentRow, currentColumn));
        }

        int rowCount = getRowCount();

        if (currentRow < rowCount) {
            // go to next cell
            currentRow++;
            boolean canSelect = true;

            // select next cell
            if (currentRow >= rowCount) {

                if (log.isDebugEnabled()) {
                    log.debug("No next row");
                }
                if (isCreateNewRow()) {

                    // create a new row in model
                    addNewRow();

                } else {
                    canSelect = false;
                }
            }

            if (canSelect) {
                doSelectCell(currentRow, currentColumn);
            }
        }
    }
}
