package org.nuiton.jaxx.application.swing.tab;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import javax.swing.JTabbedPane;

/**
 * Created on 11/25/13.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public interface TabContainerHandler {

    JTabbedPane getTabPanel();

    void init();

    /**
     * Method called when the user selects a tab.
     *
     * @param currentIndex
     * @param newIndex
     * @return <code>false</code> if you want to prevent the tab change,
     * <code>true</code> otherwise
     */
    boolean onTabChanged(int currentIndex, int newIndex);

    /**
     * Returns the tab handler of the tab i.
     *
     * @param index the index of the tab
     * @return the tab handler of the index i if the handler implements
     * the {@link TabHandler} interface,
     * <code>null</code> otherwise
     */
    TabHandler getTabHandler(int index);

    /**
     * Sets a {@link CustomTab} as tab component.
     *
     * @param index
     * @param model
     */
    void setCustomTab(int index, TabContentModel model);

    /**
     * Removes the tab i
     *
     * @param i the index of the tab to remove
     * @return <code>false</code> if you want to prevent the tab close,
     * <code>true</code> otherwise
     */
    boolean removeTab(int i);

}
