package org.nuiton.jaxx.application.swing.action;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.application.type.ApplicationProgressionModel;

/**
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public class ApplicationActionUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_ACTION = "action";

    public static final String PROPERTY_PROGRESSION_MODEL = "progressionModel";

    protected AbstractApplicationAction action;

    protected ApplicationProgressionModel progressionModel;

    public ApplicationProgressionModel getProgressionModel() {
        return progressionModel;
    }

    public void setProgressionModel(ApplicationProgressionModel progressionModel) {
        Object oldValue = getProgressionModel();
        this.progressionModel = progressionModel;
        firePropertyChange(PROPERTY_PROGRESSION_MODEL, oldValue, progressionModel);
    }

    public AbstractApplicationAction getAction() {
        return action;
    }

    public void setAction(AbstractApplicationAction action) {
        Preconditions.checkNotNull(action, "action can not be null");
        Object oldValue = getAction();
        this.action = action;
        firePropertyChange(PROPERTY_ACTION, oldValue, action);
    }

    public void clear() {
        setProgressionModel(null);

        Object oldValue = getAction();
        action = null;
        firePropertyChange(PROPERTY_ACTION, oldValue, null);
    }
}
