/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.nuiton.guix.GuixLauncher;
import org.nuiton.guix.GwtGuixInitializer;
import org.nuiton.guix.SwingGuixInitializer;
import org.nuiton.guix.generator.GwtGenerator;
import org.nuiton.guix.generator.SwingGenerator;

public class GuixMojo
extends AbstractMojo {
    protected MavenProject project;
    private String guixFilesDir;
    private String guixFilesBaseDir;
    private String targetDirectory;
    private String mainClass;
    private String generationLanguage;
    private String launcherName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File guixFilesBaseDir = new File(this.guixFilesBaseDir);
        File guixFilesDir = new File(this.guixFilesDir);
        File targetDirectory = new File(this.targetDirectory);
        Class<SwingGenerator> generatorClass = null;
        if (this.generationLanguage.equalsIgnoreCase("Swing")) {
            generatorClass = SwingGenerator.class;
            SwingGuixInitializer.initialize();
            this.fixCompileSourceRoots(targetDirectory);
        } else if (this.generationLanguage.equalsIgnoreCase("GWT")) {
            generatorClass = GwtGenerator.class;
            GwtGuixInitializer.initialize();
            this.fixCompileSourceRoots(new File(targetDirectory, "java"));
        }
        if (guixFilesDir.exists() && guixFilesDir.isDirectory()) {
            ArrayList<File> guixFiles = this.goDeeperInto(guixFilesDir);
            GuixLauncher gcl = new GuixLauncher(guixFiles.toArray(new File[guixFiles.size()]), targetDirectory, guixFilesBaseDir, this.mainClass, generatorClass, this.generationLanguage, this.launcherName);
            boolean result = gcl.compile();
            if (result) {
                this.getLog().info((CharSequence)"Compilation succeeded !");
            } else {
                this.getLog().error((CharSequence)"Compilation failed...");
            }
            this.getLog().info((CharSequence)"Compilation over");
        } else {
            this.getLog().error((CharSequence)"Sources not found.");
        }
    }

    private ArrayList<File> goDeeperInto(File dir) {
        this.getLog().debug((CharSequence)("goind deeper into " + dir.getPath()));
        ArrayList<File> result = new ArrayList<File>();
        for (File f : dir.listFiles()) {
            if (f.isDirectory() && !f.isHidden()) {
                result.addAll(this.goDeeperInto(f));
                continue;
            }
            if (!f.getName().endsWith(".guix") && !f.getName().endsWith(".jaxx")) continue;
            this.getLog().debug((CharSequence)("found " + f.getName()));
            result.add(f);
        }
        return result;
    }

    protected void fixCompileSourceRoots(File targetDirectory) {
        if (this.project != null && !this.project.getCompileSourceRoots().contains(targetDirectory.getPath())) {
            this.project.addCompileSourceRoot(targetDirectory.getPath());
        }
    }
}

