/**
 * *##% guix-compiler
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.nuiton.guix.model;

/**
 * Descriptor of a class found in the guix files.
 *
 * @author morin
 */
public class ClassDescriptor {

    /** Name of the class */
    private String name;

    /** Package of the class (must ends with '.*') */
    private String packageName;

    /**
     * Script declared in the guix file.
     *  Available only for the root GuixModelObject class.
     */
    private String script;

    /**
     * Superclass of the class
     *  Available only for the root GuixModelObject class.
     */
    private ClassDescriptor superClass;

    /**
     * Constructor
     *
     * @param name          name of the class
     * @param packageName   name of the package
     */
    public ClassDescriptor(String name, String packageName) {
        this.name        = name;
        this.packageName = packageName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getScript() {
        return script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public ClassDescriptor getSuperClass() {
        return superClass;
    }

    public void setSuperClass(ClassDescriptor superClass) {
        this.superClass = superClass;
    }

    public String toString() {
        return (packageName != null)
               ? packageName + "." + name
               : name;
    }
}

