/**
 * *##% guix-compiler-gwt
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.tags.gwt;

import org.nuiton.guix.model.AttributeDescriptor;
import org.nuiton.guix.model.GuixModelObject;

/**
 * Represents a row of a table
 *
 * @author kmorin
 */
public class RowHandler extends TableHandler {
    
    /** index of the row */
    private int row = -1;

    /**
     * Constructor
     */
    public RowHandler() {
        super();
    }

    /**
     * Constructor
     *
     * @param row the GuixModelObject which represents the row
     */
   public RowHandler(GuixModelObject row) {
       for (AttributeDescriptor attr : row.getAttributeDescriptors()) {
            if (attr.getName().equals("row")) {
                this.row = Integer.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("weightx")) {
                weightx = Double.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("weighty")) {
                weighty = Double.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("ipadx")) {
                ipadx = Integer.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("ipady")) {
                ipady = Integer.valueOf(attr.getValue());
            }
            else if (attr.getName().equals("horizontalAlignment")) {
                horizontalAlignment = getHalign(attr.getValue());
            }
            else if (attr.getName().equals("verticalAlignment")) {
                verticalAlignment = getValign(attr.getValue());
            }
            else if (attr.getName().equals("fill")) {
                fill = attr.getValue();
            }
            else if (attr.getName().equals("insets")) {
                insets = attr.getValue();
            }
        }
   }

   /**
     * Constructor
     *
     * @param row the GuixModelObject which represents the row
     * @param table the table which contains the row
     */
    public RowHandler(GuixModelObject row, TableHandler table) {
        this(row);
        //if the attributes that the table contains too have not been defined by the user within the row,
        //but have been defined in the table, set them
        if (horizontalAlignment == null) {
            horizontalAlignment = table.getHorizontalAlignment() == null ? TableHandler.DEFAULT_HORIZONTAL_ALIGNMENT : table.getHorizontalAlignment();
        }
        if (verticalAlignment == null) {
            verticalAlignment = table.getVerticalAlignment() == null ? TableHandler.DEFAULT_VERTICAL_ALIGNMENT : table.getVerticalAlignment();
        }
        if (fill == null) {
            fill = table.getFill() == null ? TableHandler.DEFAULT_FILL : table.getFill();
        }
        if (insets == null) {
            insets = table.getInsets() == null ? TableHandler.DEFAULT_INSETS : table.getInsets();
        }
        if (ipadx == null) {
            ipadx = table.getIpadx() == null ? TableHandler.DEFAULT_IPADX : table.getIpadx();
        }
        if (ipady == null) {
            ipady = table.getIpady() == null ? TableHandler.DEFAULT_IPADY : table.getIpady();
        }
        if (weightx == null) {
            weightx = table.getWeightx() == null ? TableHandler.DEFAULT_WEIGHTX : table.getWeightx();
        }
        if (weighty == null) {
            weighty = table.getWeighty() == null ? TableHandler.DEFAULT_WEIGHTY : table.getWeighty();
        }
    }

    @Override
    public Class getClassToGenerate() {
        return null;
    }

    public int getRow() {
        return row;
    }

    public void setRow(int row) {
        this.row = row;
    }
}
