/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.nuiton.eugene.plugin.writer.BaseChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;
import org.nuiton.util.FasterCachedResourceResolver;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;
import org.nuiton.util.ResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmiChainedFileWriter
extends BaseChainedFileWriter {
    public static final String PROP_RESOLVER = "resolver";
    public static final String PROP_FULL_PACKAGE_PATH = "fullPackagePath";
    protected TransformerFactory transformerFactory;

    public XmiChainedFileWriter() {
        super(PROP_RESOLVER, PROP_RESOLVER, PROP_FULL_PACKAGE_PATH, PROP_FULL_PACKAGE_PATH);
    }

    public boolean acceptModel(String modelType) {
        return this.acceptObjectModelOrStateModel(modelType);
    }

    public String getInputProtocol() {
        return "xmi";
    }

    public String getOutputProtocol(String modelType) {
        return "model";
    }

    public boolean acceptInclude(String include) {
        return include.startsWith("xmi:") || include.endsWith(".xmi") || include.endsWith(".uml");
    }

    public String getDefaultIncludes() {
        return "**/*.xmi";
    }

    public String getDefaultInputDirectory() {
        return "src/main/xmi";
    }

    public String getDefaultOutputDirectory() {
        return "models";
    }

    public String getDefaultTestInputDirectory() {
        return "src/test/xmi";
    }

    public String getDefaultTestOutputDirectory() {
        return "test-models";
    }

    protected TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
        }
        return this.transformerFactory;
    }

    public String getFullPackagePath() {
        return (String)this.getProperty(PROP_FULL_PACKAGE_PATH, String.class);
    }

    public String getResolver() {
        return (String)this.getProperty(PROP_RESOLVER, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(ChainedFileWriterConfiguration configuration, File outputDir, File inputDirectory, String includePattern) throws IOException {
        long t0 = System.nanoTime();
        boolean overwrite = configuration.isOverwrite();
        try {
            this.getLog().info((CharSequence)("Processing XSL tranformation on " + inputDirectory + " for " + includePattern));
            this.getLog().info((CharSequence)(" with fullPackagePath   : " + this.getFullPackagePath()));
            this.getLog().info((CharSequence)(" with resolver          : " + this.getResolver()));
            List files = PluginHelper.getIncludedFiles((File)inputDirectory, (String[])new String[]{includePattern}, null);
            this.actionXsl(configuration, outputDir, inputDirectory, files, overwrite);
        }
        finally {
            this.getLog().info((CharSequence)("xsl done in " + PluginHelper.convertTime((long)(System.nanoTime() - t0))));
        }
        this.getLog().info((CharSequence)"Copy resources files");
        PluginIOContext ioContext = new PluginIOContext();
        ioContext.setInput(inputDirectory);
        ioContext.setOutput(outputDir);
        PluginHelper.copyFiles((PluginIOContext)ioContext, null, (String[])new String[]{includePattern}, (boolean)overwrite);
    }

    protected void actionXsl(ChainedFileWriterConfiguration configuration, File outputDir, File dir, List<File> files, boolean overwrite) throws IOException {
        for (File file : files) {
            try {
                boolean b;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("treate file : " + file));
                }
                URIResolver fileResolver = this.getUriResolver(configuration, file);
                String styleSheet = this.getStyleSheet(configuration.getModelType(), file);
                URL xsl = Resource.getURL((String)styleSheet);
                String extension = "." + FileUtil.extension((File)file, (String[])new String[0]);
                String filename = FileUtil.basename((File)file, (String[])new String[]{extension}).concat(".").concat(configuration.getModelType());
                String relatifPath = file.getParentFile().getAbsolutePath().substring(dir.getAbsolutePath().length());
                File dstDir = outputDir;
                if (!(relatifPath.isEmpty() || (dstDir = new File(dstDir, relatifPath)).exists() || (b = dstDir.mkdirs()))) {
                    throw new IOException("could not create directory " + dstDir);
                }
                File result = new File(dstDir, filename);
                if (!overwrite && file.lastModified() < result.lastModified()) {
                    this.getLog().info((CharSequence)("file up-to-date : " + result));
                    continue;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("generate " + result));
                }
                Transformer transformer = this.getTransformerFactory().newTransformer(new StreamSource(xsl.openStream()));
                transformer.setParameter(PROP_FULL_PACKAGE_PATH, this.getFullPackagePath());
                transformer.setURIResolver(fileResolver);
                transformer.transform(new StreamSource(file), new StreamResult(new FileOutputStream(result)));
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    protected URIResolver getUriResolver(ChainedFileWriterConfiguration configuration, File model) {
        URIResolver result = null;
        try {
            ClassLoader loader = configuration.getClassLoader();
            Class<?> clazz = Class.forName(this.getResolver(), true, loader);
            try {
                Constructor<?> withBaseConstructor = clazz.getConstructor(String.class);
                String base = model.getParentFile().getAbsolutePath();
                result = (URIResolver)withBaseConstructor.newInstance(base);
            }
            catch (Exception eee) {
                this.getLog().warn((CharSequence)"Unable to instantiate resolver with String parameter", (Throwable)eee);
            }
            if (result == null) {
                result = (URIResolver)clazz.newInstance();
            }
            if (result instanceof ResourceResolver) {
                ((ResourceResolver)result).setVerbose(configuration.isVerbose());
                ((ResourceResolver)result).setCl(loader);
                if (result instanceof FasterCachedResourceResolver) {
                    boolean offline = configuration.isOffline();
                    this.getLog().debug((CharSequence)("using offline mode  ? : " + offline));
                    ((FasterCachedResourceResolver)result).setOffline(offline);
                }
            }
        }
        catch (Exception eee) {
            this.getLog().warn((CharSequence)"Unable to instantiate resolver using the default constructor", (Throwable)eee);
        }
        return result;
    }

    protected String getStyleSheet(String modelType, File model) {
        if ("objectmodel".equals(modelType)) {
            String version = this.getXmiVersion(model);
            String styleSheet = null;
            if (version.startsWith("1.")) {
                styleSheet = "xmi1.2ToObjectModel.xsl";
            } else if (version.startsWith("2.")) {
                styleSheet = "xmi2.1ToObjectModel.xsl";
            } else {
                this.getLog().error((CharSequence)("Unsupported xmi version [" + version + "]"));
            }
            return styleSheet;
        }
        if ("statemodel".equals(modelType)) {
            return "xmi1.2ToStateModel.xsl";
        }
        throw new IllegalStateException("unsupported modelType [" + modelType + "]");
    }

    protected String getXmiVersion(File xmiFile) {
        String version = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            XmiVersionHandler handler = new XmiVersionHandler();
            parser.parse(xmiFile, (DefaultHandler)handler);
            version = handler.getVersion();
        }
        catch (ParserConfigurationException e) {
            this.getLog().debug((CharSequence)"Can't parse file as xmi", (Throwable)e);
        }
        catch (SAXException e) {
            this.getLog().debug((CharSequence)"Can't parse file as xmi", (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"Can't parse file as xmi", (Throwable)e);
        }
        return version;
    }

    protected class XmiVersionHandler
    extends DefaultHandler {
        protected String version;

        public String getVersion() {
            return this.version;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("XMI")) {
                this.version = attributes.getValue("xmi.version");
                XmiChainedFileWriter.this.getLog().debug((CharSequence)("XMI version found : " + this.version));
            }
            if (this.version == null) {
                this.version = attributes.getValue("xmi:version");
                XmiChainedFileWriter.this.getLog().debug((CharSequence)("XMI version found : " + this.version));
            }
        }
    }
}

