/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.eugene.plugin.EugeneAbstractMojo;
import org.nuiton.util.PluginHelper;
import org.nuiton.util.PluginIOContext;

public class Zargo2Xmi
extends EugeneAbstractMojo {
    public static final String[] ZARGO_FILE_FILTER = new String[]{"**/*.zargo", "**/*.zuml"};
    public static final String[] XMI_FILE_FILTER = new String[]{"*.xmi", "**/*.xmi"};
    protected PluginIOContext zargoResources;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Extract zipped XMI files from zargo archive and copy resources");
        super.execute();
        this.getLog().info((CharSequence)"Extract zipped XMI files");
        try {
            PluginHelper.expandFiles((PluginIOContext)this.zargoResources, (String[])ZARGO_FILE_FILTER, null, (String[])XMI_FILE_FILTER, (boolean)this.overwrite);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not expand files for reason " + ex.getMessage(), (Exception)ex);
        }
        this.getLog().info((CharSequence)"Copy resources");
        try {
            PluginHelper.copyFiles((PluginIOContext)this.zargoResources, null, (String[])ZARGO_FILE_FILTER, (boolean)this.overwrite);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not copy some files for reason " + ex.getMessage(), (Exception)ex);
        }
    }

    @Override
    protected PluginIOContext getResources() {
        return this.zargoResources;
    }

    @Override
    protected PluginIOContext initResources() {
        File defaultIn = this.getFile("src", "main", "xmi");
        File defaultOut = this.getFile("target", "generated-sources", "xmi");
        File defaultTestIn = this.getFile("src", "test", "xmi");
        File defaultTestOut = this.getFile("target", "generated-sources", "test-xmi");
        this.zargoResources = this.initResources(defaultIn, defaultOut, defaultTestIn, defaultTestOut);
        return this.zargoResources;
    }
}

