/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.AbstractJavaBeanTransformer;
import org.nuiton.eugene.java.JavaTemplatesStereoTypes;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class SimpleJavaBeanWithNoInterfaceTransformer
extends AbstractJavaBeanTransformer {
    private static final Log log = LogFactory.getLog(SimpleJavaBeanWithNoInterfaceTransformer.class);

    public void transformFromClass(ObjectModelClass input) {
        ObjectModelPackage aPackage = this.getPackage((ObjectModelClassifier)input);
        if (JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)input, aPackage)) {
            String className = this.getBeanClassName(aPackage, input);
            String abstractClassName = "Abstract" + className;
            String defaultClassName = this.getBeanDefaultsClassName(aPackage, input);
            String abstractDefaultClassName = "Abstract" + defaultClassName;
            boolean generateDefaults = this.canGenerateBeanDefaults(aPackage, input);
            boolean generateAbstractClass = this.canGenerateAbstractBean(input, abstractClassName);
            boolean generateClass = this.canGenerateBean(input, className);
            String prefix = this.getConstantPrefix((ObjectModelClassifier)input);
            this.setConstantPrefix(prefix);
            if (generateAbstractClass) {
                this.generateAbstractBeanClass(aPackage, input, abstractClassName);
            }
            if (generateClass) {
                this.generateBeanClass(input, className, abstractClassName);
            }
            if (generateDefaults) {
                this.generateBeanDefaults(aPackage, input, className, abstractDefaultClassName, defaultClassName);
            }
        }
    }

    protected boolean canGenerateAbstractBean(ObjectModelClass input, String className) {
        String fqn = input.getPackageName() + "." + className;
        boolean canGenerate = !this.isInClassPath(fqn);
        return canGenerate;
    }

    protected boolean canGenerateBean(ObjectModelClass input, String className) {
        boolean canGenerate;
        String fqn = input.getPackageName() + "." + className;
        boolean bl = canGenerate = !this.isInClassPath(fqn);
        if (canGenerate && !input.getOperations().isEmpty()) {
            canGenerate = false;
        }
        return canGenerate;
    }

    protected boolean canGenerateBeanDefaults(ObjectModelPackage aPackage, ObjectModelClass input) {
        boolean withInput = input != null;
        boolean canGenerate = this.getJavaTemplatesTagValues().isSimpleBeanWithNoInterfaceGenerateDefaults((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        if (canGenerate && withInput) {
            canGenerate = !input.isAbstract() && JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)input, aPackage);
        }
        return canGenerate;
    }

    protected ObjectModelClass generateBeanClass(ObjectModelClass input, String className, String abstractClassName) {
        ObjectModelClass output = input.isAbstract() ? this.createAbstractClass(className, input.getPackageName()) : this.createClass(className, input.getPackageName());
        this.setSuperClass(output, abstractClassName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        this.addSerializable(input, output, true);
        return output;
    }

    protected ObjectModelClass generateAbstractBeanClass(ObjectModelPackage aPackage, ObjectModelClass input, String className) {
        String superClass = null;
        boolean superClassIsBean = false;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)superclass, aPackage)) {
                    superClassIsBean = true;
                    superClass = superclass.getPackageName() + "." + this.getBeanClassName(aPackage, superclass);
                    break;
                }
                superClass = superclass.getQualifiedName();
            }
        }
        if (!superClassIsBean && (superClass = this.getJavaTemplatesTagValues().getSimpleBeanWithNoInterfaceSuperClassTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) != null) {
            superClassIsBean = true;
        }
        ObjectModelClass output = this.createAbstractClass(className, input.getPackageName());
        if (superClass != null) {
            this.setSuperClass(output, superClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        boolean serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, null);
        this.generateI18nBlockAndConstants(aPackage, input, (ObjectModelClassifier)output);
        this.addSerializable(input, output, serializableFound || superClassIsBean);
        List<ObjectModelAttribute> properties = this.getProperties(input);
        boolean usePCS = this.getJavaTemplatesTagValues().isGeneratePropertyChangeSupport((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateBooleanGetMethods = this.getEugeneTagValues().isGenerateBooleanGetMethods((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateNotEmptyCollections = this.getJavaTemplatesTagValues().isGenerateNotEmptyCollections((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        for (ObjectModelAttribute attr : properties) {
            this.createProperty(output, attr, usePCS, generateBooleanGetMethods, generateNotEmptyCollections);
        }
        if (!superClassIsBean) {
            this.addDefaultMethodForNoneBeanSuperClass(output, usePCS, properties);
        }
        return output;
    }

    protected void generateBeanDefaults(ObjectModelPackage aPackage, ObjectModelClass aClass, String typeName, String abstractClassName, String defaultClassName) {
        boolean generateDefault = this.canGenerateBeanDefaults(aPackage, aClass);
        if (!generateDefault) {
            return;
        }
        String packageName = aClass.getPackageName();
        if (!this.isInClassPath(packageName, defaultClassName)) {
            ObjectModelClass output = this.createClass(defaultClassName, packageName);
            this.setSuperClass(output, packageName + "." + abstractClassName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("will generate " + output.getQualifiedName()));
            }
        }
        if (!this.isInClassPath(packageName, abstractClassName)) {
            String superClassName = this.getJavaTemplatesTagValues().getSimpleBeanWithNoInterfaceDefaultsSuperClassTagValue((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model);
            ObjectModelClass output = this.createAbstractClass(abstractClassName, packageName);
            if (StringUtils.isNotBlank((CharSequence)superClassName)) {
                this.setSuperClass(output, superClassName);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("will generate " + output.getQualifiedName()));
            }
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "typeOf" + typeName, "<BeanType extends " + typeName + "> Class<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return (Class<BeanType>) " + typeName + ".class;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, typeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return new " + typeName + "();\n" + "    ");
            this.addImport((ObjectModelClassifier)output, Binder.class);
            this.addImport((ObjectModelClassifier)output, BinderFactory.class);
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "BeanType", "source");
            this.setOperationBody(operation, "\n        Class<BeanType> sourceType = typeOf" + typeName + "();\n" + "        Binder<BeanType,BeanType> binder = BinderFactory.newBinder(sourceType);\n" + "        BeanType result = new" + typeName + "(source, binder);\n" + "        return result;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "BeanType", "source");
            this.addParameter(operation, "Binder<BeanType, BeanType>", "binder");
            this.setOperationBody(operation, "\n        BeanType result = (BeanType) new" + typeName + "();\n" + "        binder.copy(source, result);\n" + "        return result;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "copy" + typeName, "<BeanType extends " + typeName + "> void", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "BeanType", "source");
            this.addParameter(operation, "BeanType", "target");
            this.setOperationBody(operation, "\n        Class<BeanType> sourceType = typeOf" + typeName + "();\n" + "        Binder<BeanType,BeanType> binder = BinderFactory.newBinder(sourceType);\n" + "        binder.copy(source, target);\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "copy" + typeName, "<BeanType extends " + typeName + "> void", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "BeanType", "source");
            this.addParameter(operation, "BeanType", "target");
            this.addParameter(operation, "Binder<BeanType, BeanType>", "binder");
            this.setOperationBody(operation, "\n        binder.copy(source, target);\n    ");
        }
    }

    protected Collection<ObjectModelOperation> getPublicOperations(ObjectModelClass clazz) {
        ArrayList<ObjectModelOperation> result = new ArrayList<ObjectModelOperation>();
        for (ObjectModelOperation operation : clazz.getOperations()) {
            ObjectModelJavaModifier visibility = ObjectModelJavaModifier.fromVisibility((String)operation.getVisibility());
            if (ObjectModelJavaModifier.PUBLIC != visibility) continue;
            result.add(operation);
        }
        return result;
    }

    protected String getBeanClassName(ObjectModelPackage aPackage, ObjectModelClass input) {
        String classNamePrefix = this.getJavaTemplatesTagValues().getSimpleBeanWithNoInterfaceClassNamePrefixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        String classNameSuffix = this.getJavaTemplatesTagValues().getSimpleBeanWithNoInterfaceClassNameSuffixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        return this.generateName(classNamePrefix, input.getName(), classNameSuffix);
    }

    protected String getBeanDefaultsClassName(ObjectModelPackage aPackage, ObjectModelClass input) {
        String classNamePrefix = this.getJavaTemplatesTagValues().getSimpleBeanWithNoInterfaceDefaultsClassNamePrefixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        String classNameSuffix = this.getJavaTemplatesTagValues().getSimpleBeanWithNoInterfaceDefaultsClassNameSuffixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        return this.generateName(classNamePrefix, input.getName(), classNameSuffix);
    }

    protected String generateName(String prefix, String name, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            sb.append(prefix);
        }
        sb.append(name);
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

