/*
 *  ******************************************************************************
 *  *
 *  *
 *  * This program and the accompanying materials are made available under the
 *  * terms of the Apache License, Version 2.0 which is available at
 *  * https://www.apache.org/licenses/LICENSE-2.0.
 *  *
 *  *  See the NOTICE file distributed with this work for additional
 *  *  information regarding copyright ownership.
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  * License for the specific language governing permissions and limitations
 *  * under the License.
 *  *
 *  * SPDX-License-Identifier: Apache-2.0
 *  *****************************************************************************
 */

package org.nd4j.common.primitives;

import lombok.*;

import java.io.Serializable;

@Data
@AllArgsConstructor
@Builder
public class ImmutableTriple<F, S, T> implements Serializable {
    private static final long serialVersionUID = 119L;

    protected ImmutableTriple() {

    }

    @Setter(AccessLevel.NONE) protected F first;
    @Setter(AccessLevel.NONE) protected S second;
    @Setter(AccessLevel.NONE) protected T third;


    public F getLeft() {
        return first;
    }

    public S getMiddle() {
        return second;
    }

    public T getRight() {
        return third;
    }

    public static <F, S, T> ImmutableTriple<F, S,T> tripleOf(F first, S second, T third) {
        return new ImmutableTriple<F, S, T>(first, second, third);
    }

    public static <F, S, T> ImmutableTriple<F, S,T> of(F first, S second, T third) {
        return new ImmutableTriple<F, S, T>(first, second, third);
    }
}
