/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.compression;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;

public class EncodeBitmap
extends DynamicCustomOp {
    protected float threshold = 0.001f;

    public EncodeBitmap() {
    }

    public EncodeBitmap(@NonNull INDArray updates, float threshold) {
        this(updates, Nd4j.create(DataType.INT32, updates.length() / 16L + 5L), Nd4j.scalar(DataType.INT32, 0), threshold);
        if (updates == null) {
            throw new NullPointerException("updates is marked non-null but is null");
        }
    }

    public EncodeBitmap(@NonNull INDArray updates, @NonNull INDArray encoded, @NonNull INDArray counter, float threshold) {
        if (updates == null) {
            throw new NullPointerException("updates is marked non-null but is null");
        }
        if (encoded == null) {
            throw new NullPointerException("encoded is marked non-null but is null");
        }
        if (counter == null) {
            throw new NullPointerException("counter is marked non-null but is null");
        }
        this.addInputArgument(updates);
        this.addOutputArgument(updates, encoded, counter);
        this.addTArgument(threshold);
        this.threshold = threshold;
        this.setInPlace(true);
    }

    @Override
    public String opName() {
        return "encode_bitmap";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return Arrays.asList(((INDArray)this.inputArguments.get(0)).dataType(), DataType.INT32, DataType.INT32);
    }
}

