/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import org.mule.api.MuleEventContext;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.functional.FunctionalTestComponent;

public class TransactionalFunctionalTestComponent
extends FunctionalTestComponent {
    private boolean expectTransaction = true;
    private boolean rollback = true;

    @Override
    public Object onCall(MuleEventContext context) throws Exception {
        Object replyMessage = super.onCall(context);
        if (this.expectTransaction) {
            Transaction currentTx = context.getCurrentTransaction();
            if (currentTx == null || !currentTx.isBegun()) {
                context.setStopFurtherProcessing(true);
                throw new TransactionException(MessageFactory.createStaticMessage((String)"Trying to roll back transaction but no transaction is underway."));
            }
            if (this.rollback) {
                this.logger.info((Object)"@@@@ Rolling back transaction @@@@");
                currentTx.setRollbackOnly();
            }
        }
        return replyMessage;
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public void setRollback(boolean rollback) {
        this.rollback = rollback;
    }

    public boolean isExpectTransaction() {
        return this.expectTransaction;
    }

    public void setExpectTransaction(boolean expectTransaction) {
        this.expectTransaction = expectTransaction;
    }
}

