/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLPooledConnection;
import org.mariadb.jdbc.MySQLXAConnection;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;

public class MySQLDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource {
    private String hostname = "localhost";
    private int port = 0;
    private String database = "";
    private String username = null;
    private String password = null;
    private Properties info = null;
    private JDBCUrl url;

    public MySQLDataSource(String hostname, int port, String database) {
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.info = new Properties();
    }

    public MySQLDataSource() {
        this.info = new Properties();
    }

    public void setDatabaseName(String dbName) {
        this.database = dbName;
    }

    public String getDatabaseName() {
        return this.database != null ? this.database : "";
    }

    public void setUser(String userName) {
        this.setUserName(userName);
    }

    public String getUser() {
        return this.username;
    }

    public void setUserName(String userName) {
        this.username = userName;
    }

    public String getUserName() {
        return this.username;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public int getPort() {
        return this.port;
    }

    public void setPortNumber(int p) {
        this.setPort(p);
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public void setServerName(String serverName) {
        this.hostname = serverName;
    }

    public void setProperties(String properties) {
        String[] parameters;
        for (String param : parameters = properties.split("&")) {
            String[] keyVal = param.split("=");
            this.info.setProperty(keyVal[0], keyVal[1]);
        }
    }

    public void setURL(String url) {
        this.setUrl(url);
    }

    public void setUrl(String s) {
        String baseUrl = s;
        int idx = s.lastIndexOf("?");
        if (idx > 0) {
            baseUrl = s.substring(0, idx);
            String urlParams = s.substring(idx + 1);
            this.setProperties(urlParams);
        }
        this.url = JDBCUrl.parse(baseUrl);
        String tmpStr = this.url.getDatabase();
        if (tmpStr != null) {
            this.database = tmpStr;
        }
        if ((tmpStr = this.url.getHostname()) != null) {
            this.hostname = tmpStr;
        }
        if (!(tmpStr = this.url.getUsername()).equals("")) {
            this.username = tmpStr;
        }
        if (!(tmpStr = this.url.getPassword()).equals("")) {
            this.password = tmpStr;
        }
        this.port = this.url.getPort();
    }

    public String getServerName() {
        return this.hostname != null ? this.hostname : "";
    }

    void createUrl() {
        if (this.url != null) {
            return;
        }
        String urlString = "jdbc:mysql://" + this.hostname;
        if (this.port != 0) {
            urlString = urlString + ":" + this.port;
        }
        if (this.database != null) {
            urlString = urlString + "/" + this.database;
        }
        this.url = JDBCUrl.parse(urlString);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.createUrl();
        try {
            return MySQLConnection.newConnection(new MySQLProtocol(this.url, this.username, this.password, this.info));
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, null, null);
            return null;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.createUrl();
        try {
            return MySQLConnection.newConnection(new MySQLProtocol(this.url, username, password, new Properties()));
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, null, null);
            return null;
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new MySQLPooledConnection((MySQLConnection)this.getConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new MySQLPooledConnection((MySQLConnection)this.getConnection(user, password));
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return new MySQLXAConnection((MySQLConnection)this.getConnection());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return new MySQLXAConnection((MySQLConnection)this.getConnection(user, password));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

