/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.linguafranca.pwdb.base.AbstractGroup;
import org.linguafranca.pwdb.kdbx.simple.SimpleDatabase;
import org.linguafranca.pwdb.kdbx.simple.SimpleEntry;
import org.linguafranca.pwdb.kdbx.simple.SimpleIcon;
import org.linguafranca.pwdb.kdbx.simple.converter.KeePassBooleanConverter;
import org.linguafranca.pwdb.kdbx.simple.converter.UuidConverter;
import org.linguafranca.pwdb.kdbx.simple.model.Times;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Transient;
import org.simpleframework.xml.convert.Convert;

@Root(name="Group")
public class SimpleGroup
extends AbstractGroup<SimpleDatabase, SimpleGroup, SimpleEntry, SimpleIcon> {
    @Element(name="UUID", type=UUID.class)
    @Convert(value=UuidConverter.class)
    protected UUID uuid;
    @Element(name="Name")
    protected String name;
    @Element(name="Notes", required=false)
    protected String notes;
    @Element(name="IconID")
    protected int iconID;
    @Element(name="Times")
    protected Times times;
    @Element(name="IsExpanded", required=false, type=Boolean.class)
    @Convert(value=KeePassBooleanConverter.class)
    protected Boolean isExpanded;
    @Element(name="DefaultAutoTypeSequence", required=false)
    protected String defaultAutoTypeSequence;
    @Element(name="EnableAutoType", required=false, type=Boolean.class)
    @Convert(value=KeePassBooleanConverter.class)
    protected Boolean enableAutoType;
    @Element(name="EnableSearching", required=false, type=Boolean.class)
    @Convert(value=KeePassBooleanConverter.class)
    protected Boolean enableSearching;
    @Element(name="LastTopVisibleEntry", required=false, type=UUID.class)
    @Convert(value=UuidConverter.class)
    protected UUID lastTopVisibleEntry;
    @ElementList(inline=true, required=false)
    protected List<SimpleEntry> entry = new ArrayList<SimpleEntry>();
    @ElementList(inline=true, required=false)
    protected List<SimpleGroup> group = new ArrayList<SimpleGroup>();
    @Transient
    protected SimpleDatabase database;
    @Transient
    protected SimpleGroup parent;

    protected SimpleGroup() {
        this.times = new Times();
    }

    public static SimpleGroup createGroup(SimpleDatabase database) {
        SimpleGroup group = new SimpleGroup();
        group.database = database;
        group.iconID = 0;
        group.name = "";
        group.uuid = UUID.randomUUID();
        return group;
    }

    public boolean isRootGroup() {
        return ((Object)((Object)this.database.getRootGroup())).equals((Object)this);
    }

    public boolean isRecycleBin() {
        return this.database.keePassFile.meta.recycleBinUUID.equals(this.uuid);
    }

    public SimpleGroup getParent() {
        return this.parent;
    }

    public void setParent(SimpleGroup group) {
        if (this.isRootGroup()) {
            throw new IllegalStateException("Cannot add root group to another group");
        }
        if (this.database != group.database) {
            throw new IllegalStateException("Must be from same database");
        }
        if (this.parent != null) {
            this.parent.removeGroup(group);
            this.parent.touch();
        }
        this.parent = group;
        this.parent.touch();
        this.touch();
    }

    public List<SimpleGroup> getGroups() {
        ArrayList<SimpleGroup> result = new ArrayList<SimpleGroup>();
        for (SimpleGroup aGroup : this.group) {
            result.add(aGroup);
        }
        return result;
    }

    public int getGroupsCount() {
        return this.group.size();
    }

    public SimpleGroup addGroup(SimpleGroup group) {
        if (group.isRootGroup()) {
            throw new IllegalStateException("Cannot add root group to another group");
        }
        if (this.database != group.database) {
            throw new IllegalStateException("Must be from same database");
        }
        if (group.getParent() != null) {
            group.getParent().removeGroup(group);
        }
        group.parent = this;
        this.group.add(group);
        this.touch();
        return group;
    }

    public SimpleGroup removeGroup(SimpleGroup group) {
        if (this.database != group.database) {
            throw new IllegalStateException("Must be from same database");
        }
        this.group.remove((Object)group);
        group.parent = null;
        this.touch();
        return group;
    }

    public List<SimpleEntry> getEntries() {
        ArrayList<SimpleEntry> result = new ArrayList<SimpleEntry>();
        for (SimpleEntry entry : this.entry) {
            result.add(entry);
        }
        return result;
    }

    public int getEntriesCount() {
        return this.entry.size();
    }

    public SimpleEntry addEntry(SimpleEntry entry) {
        if (this.database != entry.database) {
            throw new IllegalStateException("Must be from same database");
        }
        if (entry.getParent() != null) {
            entry.getParent().removeEntry(entry);
        }
        this.entry.add(entry);
        entry.parent = this;
        this.touch();
        return entry;
    }

    public SimpleEntry removeEntry(SimpleEntry entry) {
        if (this.database != entry.database) {
            throw new IllegalStateException("Must be from same database");
        }
        this.entry.remove((Object)entry);
        entry.parent = null;
        return entry;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
        this.touch();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public SimpleIcon getIcon() {
        return new SimpleIcon(this.iconID);
    }

    public void setIcon(SimpleIcon icon) {
        this.iconID = icon.getIndex();
        this.touch();
    }

    public SimpleDatabase getDatabase() {
        return this.database;
    }

    private void touch() {
        this.times.setLastModificationTime(new Date());
        this.database.setDirty(true);
    }
}

