/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme.beans;

import freemarker.template.TemplateModelException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.theme.beans.MessageFormatterMethod;

public class MessageFormatterMethodTest {
    @Test
    public void test() throws TemplateModelException {
        Locale locale = Locale.US;
        Properties properties = new Properties();
        properties.setProperty("backToApplication", "Back to application");
        properties.setProperty("backToClient", "Back to {0}");
        properties.setProperty("client_admin-console", "Admin Console");
        properties.setProperty("realm_example-realm", "Example Realm");
        MessageFormatterMethod fmt = new MessageFormatterMethod(locale, properties);
        String msg = (String)fmt.exec(Arrays.asList("backToClient", "${client_admin-console}"));
        Assert.assertEquals((Object)"Back to Admin Console", (Object)msg);
        msg = (String)fmt.exec(Arrays.asList("backToClient", "client_admin-console"));
        Assert.assertEquals((Object)"Back to client_admin-console", (Object)msg);
        msg = (String)fmt.exec(Arrays.asList("backToClient", "client '${client_admin-console}' from '${realm_example-realm}'."));
        Assert.assertEquals((Object)"Back to client 'Admin Console' from 'Example Realm'.", (Object)msg);
    }
}

