/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sessions;

import java.util.regex.Pattern;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AuthenticationSessionCompoundId {
    private static final Pattern DOT = Pattern.compile("\\.");
    private final String rootSessionId;
    private final String tabId;
    private final String clientUUID;
    private final String encodedId;

    public static AuthenticationSessionCompoundId fromAuthSession(AuthenticationSessionModel authSession) {
        return AuthenticationSessionCompoundId.decoded(authSession.getParentSession().getId(), authSession.getTabId(), authSession.getClient().getId());
    }

    public static AuthenticationSessionCompoundId decoded(String rootAuthSessionId, String tabId, String clientUUID) {
        String encodedId = rootAuthSessionId + "." + tabId + "." + clientUUID;
        return new AuthenticationSessionCompoundId(rootAuthSessionId, tabId, clientUUID, encodedId);
    }

    public static AuthenticationSessionCompoundId encoded(String encodedId) {
        String[] decoded = DOT.split(encodedId, 3);
        String rootAuthSessionId = decoded.length > 0 ? decoded[0] : null;
        String tabId = decoded.length > 1 ? decoded[1] : null;
        String clientUUID = decoded.length > 2 ? decoded[2] : null;
        return new AuthenticationSessionCompoundId(rootAuthSessionId, tabId, clientUUID, encodedId);
    }

    public AuthenticationSessionCompoundId(String rootSessionId, String tabId, String clientUUID, String encodedId) {
        this.rootSessionId = rootSessionId;
        this.tabId = tabId;
        this.clientUUID = clientUUID;
        this.encodedId = encodedId;
    }

    public String getRootSessionId() {
        return this.rootSessionId;
    }

    public String getTabId() {
        return this.tabId;
    }

    public String getClientUUID() {
        return this.clientUUID;
    }

    public String getEncodedId() {
        return this.encodedId;
    }
}

