/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonUtils {
    private static final Pattern CLAIM_COMPONENT = Pattern.compile("^((\\\\.|[^\\\\.])+?)\\.");
    private static final Pattern BACKSLASHED_CHARACTER = Pattern.compile("\\\\(.)");

    public static List<String> splitClaimPath(String claim) {
        LinkedList<String> claimComponents = new LinkedList<String>();
        Matcher m = CLAIM_COMPONENT.matcher(claim);
        int start = 0;
        while (m.find()) {
            claimComponents.add(BACKSLASHED_CHARACTER.matcher(m.group(1)).replaceAll("$1"));
            start = m.end();
            m.region(start, claim.length());
        }
        if (claim.length() > start) {
            claimComponents.add(BACKSLASHED_CHARACTER.matcher(claim.substring(start)).replaceAll("$1"));
        }
        return claimComponents;
    }

    public static boolean hasPath(String claim) {
        return CLAIM_COMPONENT.matcher(claim).find();
    }

    public static Object getJsonValue(JsonNode node, String claim) {
        if (node != null) {
            List<String> fields = JsonUtils.splitClaimPath(claim);
            if (fields.isEmpty() || claim.endsWith(".")) {
                return null;
            }
            JsonNode currentNode = node;
            Iterator<String> iterator = fields.iterator();
            while (iterator.hasNext()) {
                String currentFieldName;
                String currentNodeName = currentFieldName = iterator.next();
                int arrayIndex = -1;
                if (currentFieldName.endsWith("]")) {
                    int bi = currentFieldName.indexOf("[");
                    if (bi == -1) {
                        return null;
                    }
                    try {
                        String is = currentFieldName.substring(bi + 1, currentFieldName.length() - 1).trim();
                        arrayIndex = Integer.parseInt(is);
                        if (arrayIndex < 0) {
                            throw new ArrayIndexOutOfBoundsException();
                        }
                    }
                    catch (Exception e) {
                        return null;
                    }
                    currentNodeName = currentFieldName.substring(0, bi).trim();
                }
                currentNode = currentNode.get(currentNodeName);
                if (arrayIndex > -1 && currentNode.isArray()) {
                    currentNode = currentNode.get(arrayIndex);
                }
                if (currentNode == null) {
                    return null;
                }
                if (currentNode.isArray()) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (JsonNode childNode : currentNode) {
                        if (!childNode.isTextual()) continue;
                        values.add(childNode.textValue());
                    }
                    if (values.isEmpty()) {
                        return null;
                    }
                    return values;
                }
                if (currentNode.isNull()) {
                    return null;
                }
                if (!currentNode.isValueNode()) continue;
                String ret = currentNode.asText();
                if (ret != null && !ret.trim().isEmpty()) {
                    return ret.trim();
                }
                return null;
            }
            return currentNode;
        }
        return null;
    }
}

