/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.keycloak.config.Option;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

public class WildcardPropertyMapper<T>
extends PropertyMapper<T> {
    private final Matcher fromWildcardMatcher;
    private final Pattern fromWildcardPattern;
    private final Pattern envVarNameWildcardPattern;
    private Matcher toWildcardMatcher;
    private Pattern toWildcardPattern;
    private final Function<Set<String>, Set<String>> wildcardKeysTransformer;
    private final PropertyMapper.ValueMapper wildcardMapFrom;

    public WildcardPropertyMapper(Option<T> option, String to, BooleanSupplier enabled, String enabledWhen, BiFunction<String, ConfigSourceInterceptorContext, String> mapper, String mapFrom, BiFunction<String, ConfigSourceInterceptorContext, String> parentMapper, String paramLabel, boolean mask, BiConsumer<PropertyMapper<T>, ConfigValue> validator, String description, BooleanSupplier required, String requiredWhen, Matcher fromWildcardMatcher, Function<Set<String>, Set<String>> wildcardKeysTransformer, PropertyMapper.ValueMapper wildcardMapFrom) {
        super(option, to, enabled, enabledWhen, mapper, mapFrom, parentMapper, paramLabel, mask, validator, description, required, requiredWhen, null);
        this.wildcardMapFrom = wildcardMapFrom;
        this.fromWildcardMatcher = fromWildcardMatcher;
        this.fromWildcardPattern = Pattern.compile("(?:--|kc\\.)" + fromWildcardMatcher.replaceFirst("([\\\\\\\\.a-zA-Z0-9]+)"));
        Matcher envVarMatcher = Option.WILDCARD_PLACEHOLDER_PATTERN.matcher(option.getKey().toUpperCase().replace("-", "_"));
        this.envVarNameWildcardPattern = Pattern.compile("KC_" + envVarMatcher.replaceFirst("([_A-Z0-9]+)"));
        if (to != null) {
            this.toWildcardMatcher = Option.WILDCARD_PLACEHOLDER_PATTERN.matcher(to);
            if (!this.toWildcardMatcher.find()) {
                throw new IllegalArgumentException("Attempted to map a wildcard option to a non-wildcard option");
            }
            this.toWildcardPattern = Pattern.compile(this.toWildcardMatcher.replaceFirst("([\\\\\\\\.a-zA-Z0-9]+)"));
        }
        this.wildcardKeysTransformer = wildcardKeysTransformer;
    }

    @Override
    public boolean hasWildcard() {
        return true;
    }

    String getTo(String wildcardKey) {
        return this.toWildcardMatcher.replaceFirst(wildcardKey);
    }

    String getFrom(String wildcardKey) {
        return "kc." + this.fromWildcardMatcher.replaceFirst(wildcardKey);
    }

    @Override
    public List<ConfigValue> getKcConfigValues() {
        return this.getWildcardKeys().stream().map(v -> Configuration.getConfigValue(this.getFrom((String)v))).toList();
    }

    public Set<String> getWildcardKeys() {
        Set<String> values = StreamSupport.stream(Configuration.getPropertyNames().spliterator(), false).map(n -> this.getMappedKey((String)n, false)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (this.wildcardKeysTransformer != null) {
            return this.wildcardKeysTransformer.apply(values);
        }
        return values;
    }

    private Optional<String> getMappedKey(String originalKey, boolean tryTo) {
        Matcher matcher = this.fromWildcardPattern.matcher(originalKey);
        if (matcher.matches()) {
            return Optional.of(matcher.group(1));
        }
        if (tryTo && this.toWildcardPattern != null && (matcher = this.toWildcardPattern.matcher(originalKey)).matches()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    public Set<String> getToWithWildcards() {
        if (this.toWildcardMatcher == null) {
            return Set.of();
        }
        return this.getWildcardKeys().stream().map(v -> this.toWildcardMatcher.replaceFirst((String)v)).collect(Collectors.toSet());
    }

    public boolean matchesWildcardOptionName(String name) {
        return this.fromWildcardPattern.matcher(name).matches() || this.envVarNameWildcardPattern.matcher(name).matches() || this.toWildcardPattern != null && this.toWildcardPattern.matcher(name).matches();
    }

    @Override
    public PropertyMapper<?> forEnvKey(String key) {
        Matcher matcher = this.envVarNameWildcardPattern.matcher(key);
        if (!matcher.matches()) {
            throw new IllegalStateException("Env var '" + key + "' does not match the expected pattern '" + String.valueOf(this.envVarNameWildcardPattern) + "'");
        }
        String value = matcher.group(1);
        String wildcardValue = value.toLowerCase().replace("_", ".");
        return this.forWildcardValue(wildcardValue);
    }

    private PropertyMapper<?> forWildcardValue(String wildcardValue) {
        String to = this.getTo(wildcardValue);
        String from = this.getFrom(wildcardValue);
        return new PropertyMapper(this, from, to, this.wildcardMapFrom == null ? null : (v, context) -> this.wildcardMapFrom.map(wildcardValue, (String)v, (ConfigSourceInterceptorContext)context));
    }

    @Override
    public PropertyMapper<?> forKey(String key) {
        String wildcardValue = this.getMappedKey(key, true).orElseThrow();
        return this.forWildcardValue(wildcardValue);
    }
}

