/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayInputStream;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkIHDR
extends PngChunk {
    private int cols;
    private int rows;
    private int bitspc;
    private int colormodel;
    private int compmeth;
    private int filmeth;
    private int interlaced;

    public PngChunkIHDR(ImageInfo imageInfo) {
        super("IHDR", imageInfo);
    }

    @Override
    public ChunkRaw createChunk() {
        ChunkRaw chunkRaw = new ChunkRaw(13, ChunkHelper.b_IHDR, true);
        int n = 0;
        PngHelper.writeInt4tobytes(this.cols, chunkRaw.data, n);
        PngHelper.writeInt4tobytes(this.rows, chunkRaw.data, n += 4);
        n += 4;
        chunkRaw.data[n++] = (byte)this.bitspc;
        chunkRaw.data[n++] = (byte)this.colormodel;
        chunkRaw.data[n++] = (byte)this.compmeth;
        chunkRaw.data[n++] = (byte)this.filmeth;
        chunkRaw.data[n++] = (byte)this.interlaced;
        return chunkRaw;
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 13) {
            throw new PngjException("Bad IDHR len " + chunkRaw.len);
        }
        ByteArrayInputStream byteArrayInputStream = chunkRaw.getAsByteStream();
        this.cols = PngHelper.readInt4(byteArrayInputStream);
        this.rows = PngHelper.readInt4(byteArrayInputStream);
        this.bitspc = PngHelper.readByte(byteArrayInputStream);
        this.colormodel = PngHelper.readByte(byteArrayInputStream);
        this.compmeth = PngHelper.readByte(byteArrayInputStream);
        this.filmeth = PngHelper.readByte(byteArrayInputStream);
        this.interlaced = PngHelper.readByte(byteArrayInputStream);
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkIHDR pngChunkIHDR = (PngChunkIHDR)pngChunk;
        this.cols = pngChunkIHDR.cols;
        this.rows = pngChunkIHDR.rows;
        this.bitspc = pngChunkIHDR.bitspc;
        this.colormodel = pngChunkIHDR.colormodel;
        this.compmeth = pngChunkIHDR.compmeth;
        this.filmeth = pngChunkIHDR.filmeth;
        this.interlaced = pngChunkIHDR.interlaced;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int n) {
        this.cols = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public int getBitspc() {
        return this.bitspc;
    }

    public void setBitspc(int n) {
        this.bitspc = n;
    }

    public int getColormodel() {
        return this.colormodel;
    }

    public void setColormodel(int n) {
        this.colormodel = n;
    }

    public int getCompmeth() {
        return this.compmeth;
    }

    public void setCompmeth(int n) {
        this.compmeth = n;
    }

    public int getFilmeth() {
        return this.filmeth;
    }

    public void setFilmeth(int n) {
        this.filmeth = n;
    }

    public int getInterlaced() {
        return this.interlaced;
    }

    public void setInterlaced(int n) {
        this.interlaced = n;
    }
}

