/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtVirtualFile;
import org.jetbrains.kotlin.cli.jvm.modules.JavaVersionUtilsKt;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "()V", "handlers", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$CoreJrtHandler;", "Lorg/jetbrains/annotations/NotNull;", "findFileByPath", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "path", "getProtocol", "refresh", "", "asynchronous", "", "refreshAndFindFileByPath", "splitPath", "Lkotlin/Pair;", "Companion", "CoreJrtHandler", "cli"})
public final class CoreJrtFileSystem
extends DeprecatedVirtualFileSystem {
    private final ConcurrentMap<String, CoreJrtHandler> handlers;
    private static final ConcurrentMap<File, URLClassLoader> jrtFsClassLoaderCache;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path2) {
        void jdkHomePath;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Pair<String, String> pair = this.splitPath(path2);
        String string2 = (String)pair.component1();
        String pathInImage = (String)pair.component2();
        CoreJrtHandler coreJrtHandler = (CoreJrtHandler)this.handlers.get(jdkHomePath);
        return coreJrtHandler != null ? coreJrtHandler.findFile(pathInImage) : null;
    }

    private final Pair<String, String> splitPath(String path2) {
        int separator = StringsKt.indexOf$default((CharSequence)path2, (String)"!/", (int)0, (boolean)false, (int)6, null);
        if (separator < 0) {
            throw (Throwable)new IllegalArgumentException("Path in CoreJrtFileSystem must contain a separator: " + path2);
        }
        String string2 = path2;
        int n = 0;
        String string3 = string2.substring(n, separator);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String localPath = string3;
        String string4 = path2;
        int n2 = separator + 2;
        String string5 = string4.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
        String pathInJar = string5;
        return new Pair((Object)localPath, (Object)pathInJar);
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.findFileByPath(path2);
    }

    public CoreJrtFileSystem() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(new Function(this){
            final /* synthetic */ CoreJrtFileSystem this$0;

            public final CoreJrtHandler fun(String jdkHomePath) {
                FileSystem fileSystem2;
                File jdkHome = new File(jdkHomePath);
                URI rootUri = URI.create("jrt:/");
                File file2 = org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem$Companion.access$loadJrtFsJar(CoreJrtFileSystem.Companion, jdkHome);
                if (file2 == null) {
                    return null;
                }
                File jrtFsJar = file2;
                if (JavaVersionUtilsKt.isAtLeastJava9()) {
                    fileSystem2 = FileSystems.newFileSystem(rootUri, MapsKt.mapOf((Pair)TuplesKt.to((Object)"java.home", (Object)jdkHome.getAbsolutePath())));
                } else {
                    URLClassLoader classLoader2 = (URLClassLoader)CoreJrtFileSystem.access$getJrtFsClassLoaderCache$cp().computeIfAbsent(jrtFsJar, new java.util.function.Function(jrtFsJar){
                        final /* synthetic */ File $jrtFsJar;

                        public final URLClassLoader apply(File it) {
                            return new URLClassLoader(new URL[]{this.$jrtFsJar.toURI().toURL()}, null);
                        }
                        {
                            this.$jrtFsJar = file2;
                        }
                    });
                    fileSystem2 = FileSystems.newFileSystem(rootUri, MapsKt.emptyMap(), (ClassLoader)classLoader2);
                }
                FileSystem fileSystem3 = fileSystem2;
                String string2 = jdkHomePath;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jdkHomePath");
                Path path2 = fileSystem3.getPath("", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"fileSystem.getPath(\"\")");
                return new CoreJrtHandler(this.this$0, string2, path2);
            }
            {
                this.this$0 = coreJrtFileSystem;
            }
        });
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026em.getPath(\"\"))\n        }");
        this.handlers = concurrentMap;
    }

    static {
        Companion = new Companion(null);
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"ContainerUtil.createConc\u2026p<File, URLClassLoader>()");
        jrtFsClassLoaderCache = concurrentMap;
    }

    public static final /* synthetic */ ConcurrentMap access$getJrtFsClassLoaderCache$cp() {
        return jrtFsClassLoaderCache;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$CoreJrtHandler;", "", "virtualFileSystem", "Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "jdkHomePath", "", "root", "Ljava/nio/file/Path;", "(Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;Ljava/lang/String;Ljava/nio/file/Path;)V", "getJdkHomePath", "()Ljava/lang/String;", "getVirtualFileSystem", "()Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "findFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "fileName", "cli"})
    public static final class CoreJrtHandler {
        @NotNull
        private final CoreJrtFileSystem virtualFileSystem;
        @NotNull
        private final String jdkHomePath;
        private final Path root;

        @Nullable
        public final VirtualFile findFile(@NotNull String fileName) {
            VirtualFile virtualFile2;
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Path path2 = this.root.resolve(fileName);
            if (Files.exists(path2, new LinkOption[0])) {
                Path path3 = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
                virtualFile2 = new CoreJrtVirtualFile(this, path3);
            } else {
                virtualFile2 = null;
            }
            return virtualFile2;
        }

        @NotNull
        public final CoreJrtFileSystem getVirtualFileSystem() {
            return this.virtualFileSystem;
        }

        @NotNull
        public final String getJdkHomePath() {
            return this.jdkHomePath;
        }

        public CoreJrtHandler(@NotNull CoreJrtFileSystem virtualFileSystem, @NotNull String jdkHomePath, @NotNull Path root2) {
            Intrinsics.checkNotNullParameter((Object)virtualFileSystem, (String)"virtualFileSystem");
            Intrinsics.checkNotNullParameter((Object)jdkHomePath, (String)"jdkHomePath");
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            this.virtualFileSystem = virtualFileSystem;
            this.jdkHomePath = jdkHomePath;
            this.root = root2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$Companion;", "", "()V", "jrtFsClassLoaderCache", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/io/File;", "kotlin.jvm.PlatformType", "Ljava/net/URLClassLoader;", "Lorg/jetbrains/annotations/NotNull;", "isModularJdk", "", "jdkHome", "loadJrtFsJar", "cli"})
    public static final class Companion {
        private final File loadJrtFsJar(File jdkHome) {
            File file2;
            File p1 = file2 = new File(jdkHome, "lib/jrt-fs.jar");
            boolean bl = false;
            return p1.exists() ? file2 : null;
        }

        public final boolean isModularJdk(@NotNull File jdkHome) {
            Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
            return this.loadJrtFsJar(jdkHome) != null;
        }

        private Companion() {
        }

        public static final /* synthetic */ File access$loadJrtFsJar(Companion $this, File jdkHome) {
            return $this.loadJrtFsJar(jdkHome);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

