/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client;

import java.net.URI;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.ClientInterceptorRepository;
import org.jboss.resteasy.client.core.ClientInterceptorRepositoryImpl;
import org.jboss.resteasy.client.core.ClientInvoker;
import org.jboss.resteasy.client.core.ClientInvokerInterceptorFactory;
import org.jboss.resteasy.client.core.ClientInvokerModifier;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.client.core.marshallers.ResteasyClientProxy;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Deprecated
public class ClientRequestFactory {
    private ResteasyProviderFactory providerFactory;
    private ClientExecutor executor;
    private URI base = null;
    private boolean applyDefaultInterceptors = false;
    private boolean followRedirects = false;
    private ClientInterceptorRepositoryImpl prefixInterceptors = new ClientInterceptorRepositoryImpl();
    private ClientInterceptorRepositoryImpl suffixInterceptors = new ClientInterceptorRepositoryImpl();

    public ClientRequestFactory() {
        this.init(null, null, null);
    }

    public ClientRequestFactory(URI base) {
        this.init(null, null, base);
    }

    public ClientRequestFactory(ClientExecutor executor, URI base) {
        this.init(executor, null, base);
    }

    public ClientRequestFactory(ClientExecutor executor, ResteasyProviderFactory providerFactory) {
        this.init(executor, providerFactory, null);
    }

    public ClientRequestFactory(ClientExecutor executor, ResteasyProviderFactory providerFactory, URI base) {
        this.init(executor, providerFactory, base);
    }

    private void init(ClientExecutor executor, ResteasyProviderFactory providerFactory, URI base) {
        this.providerFactory = providerFactory == null ? ResteasyProviderFactory.getInstance() : providerFactory;
        this.executor = executor == null ? new ApacheHttpClient4Executor() : executor;
        this.base = base;
    }

    public ClientRequestFactory(ClientRequestFactory other) {
        this.providerFactory = other.providerFactory;
        this.executor = other.executor;
        this.setBase(other.getBase());
        this.applyDefaultInterceptors = other.applyDefaultInterceptors;
        this.followRedirects = other.followRedirects;
        other.prefixInterceptors.copyClientInterceptorsTo(this.prefixInterceptors);
        other.suffixInterceptors.copyClientInterceptorsTo(this.suffixInterceptors);
    }

    public URI getBase() {
        return this.base;
    }

    public void setBase(URI base) {
        this.base = base;
    }

    public void enableDefaultInterceptors() {
        this.applyDefaultInterceptors = true;
    }

    public ClientInterceptorRepository getPrefixInterceptors() {
        return this.prefixInterceptors;
    }

    public ClientInterceptorRepository getSuffixInterceptors() {
        return this.suffixInterceptors;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    private void applyInterceptors(ClientInterceptorRepositoryImpl repository) {
        this.prefixInterceptors.prefixClientInterceptorsTo(repository);
        this.suffixInterceptors.copyClientInterceptorsTo(repository);
    }

    public ClientRequestFactory clone() {
        return new ClientRequestFactory(this);
    }

    public ClientRequest createRelativeRequest(String uriTemplate) {
        return this.createRequest(this.base.toString() + uriTemplate);
    }

    public ClientRequest createRequest(String uriTemplate) {
        ClientRequest clientRequest = new ClientRequest(new UriBuilderImpl().uriTemplate(uriTemplate), this.executor, this.providerFactory);
        if (this.applyDefaultInterceptors) {
            ClientInvokerInterceptorFactory.applyDefaultInterceptors(clientRequest, this.providerFactory);
        }
        if (this.followRedirects) {
            clientRequest.followRedirects();
        }
        this.applyInterceptors(clientRequest);
        return clientRequest;
    }

    public <T> T getRelative(String uriTemplate, Class<T> type, Object ... params) throws Exception {
        return this.get(this.base.toString() + uriTemplate, type, params);
    }

    public <T> T get(String uriTemplate, Class<T> type, Object ... params) throws Exception {
        return this.createRequest(uriTemplate).followRedirects(true).pathParameters(params).get(type).getEntity();
    }

    public <T> T createProxy(Class<T> clazz) {
        assert (this.base != null);
        return this.createProxy(clazz, this.base);
    }

    public <T> T createProxy(Class<T> clazz, String baseUri) {
        return this.createProxy(clazz, URI.create(baseUri));
    }

    public <T> T createProxy(Class<T> clazz, URI baseUri) {
        T proxy = ProxyFactory.create(clazz, baseUri, this.executor, this.providerFactory);
        ResteasyClientProxy clientProxy = (ResteasyClientProxy)proxy;
        clientProxy.applyClientInvokerModifier(new ClientInvokerModifier(){

            @Override
            public void modify(ClientInvoker invoker) {
                ClientRequestFactory.this.applyInterceptors(invoker);
            }
        });
        return proxy;
    }
}

