/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.LevelTranslator;

class JBossStatusListener
implements StatusListener {
    private static final String NAME = "org.jboss.logmanager.log4j.status";
    private static final Logger.AttachmentKey<StatusListener> STATUS_LISTENER_KEY = new Logger.AttachmentKey();
    private final Logger logger;
    private final LevelTranslator levelTranslator = LevelTranslator.getInstance();
    private final Level level;

    private JBossStatusListener(Logger logger) {
        this.logger = logger;
        this.level = StatusLogger.getLogger().getLevel();
    }

    static void registerIfAbsent(LogContext logContext) {
        Logger logger = logContext.getLogger(NAME);
        StatusListener listener = (StatusListener)logger.getAttachment(STATUS_LISTENER_KEY);
        if (listener == null && logger.attachIfAbsent(STATUS_LISTENER_KEY, (Object)(listener = new JBossStatusListener(logger))) == null) {
            StatusLogger.getLogger().registerListener(listener);
        }
    }

    static void remove(LogContext logContext) {
        Logger logger = logContext.getLogger(NAME);
        logger.detach(STATUS_LISTENER_KEY);
    }

    public void log(StatusData data) {
        this.logger.log(this.levelTranslator.translateLevel(data.getLevel()), data.getMessage().getFormattedMessage(), data.getThrowable());
    }

    public Level getStatusLevel() {
        return this.level;
    }

    public void close() {
        this.logger.detach(STATUS_LISTENER_KEY);
    }
}

