/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.JBossLogger;

class JBossLoggerContext
implements LoggerContext {
    private static final Logger.AttachmentKey<Map<Key, ExtendedLogger>> LOGGER_KEY = new Logger.AttachmentKey();
    private final LogContext logContext;
    private final Object externalContext;

    JBossLoggerContext(LogContext logContext, Object externalContext) {
        this.logContext = logContext;
        this.externalContext = externalContext;
    }

    public Object getExternalContext() {
        return this.externalContext;
    }

    public ExtendedLogger getLogger(String name) {
        return this.getOrCreateLogger(new Key(name, null));
    }

    public ExtendedLogger getLogger(String name, MessageFactory messageFactory) {
        return this.getOrCreateLogger(new Key(name, messageFactory));
    }

    public boolean hasLogger(String name) {
        return this.logContext.getAttachment(name, LOGGER_KEY) != null;
    }

    public boolean hasLogger(String name, MessageFactory messageFactory) {
        return this.hasLogger(name, messageFactory == null ? null : messageFactory.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        Map loggers = (Map)this.logContext.getAttachment(name, LOGGER_KEY);
        if (loggers == null) {
            return false;
        }
        Map map = loggers;
        synchronized (map) {
            for (Key key : loggers.keySet()) {
                if (messageFactoryClass == null && key.messageFactory == null) {
                    return true;
                }
                if (key.messageFactory == null || key.messageFactory.getClass() != messageFactoryClass) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedLogger getOrCreateLogger(Key key) {
        Map<Key, ExtendedLogger> loggers;
        Map<Key, ExtendedLogger> map = loggers = JBossLoggerContext.getLoggers(this.logContext, key.name);
        synchronized (map) {
            return loggers.computeIfAbsent(key, new Function<Key, ExtendedLogger>(){

                @Override
                public ExtendedLogger apply(Key key) {
                    if (key.messageFactory == null) {
                        return new JBossLogger(JBossLoggerContext.this.logContext.getLogger(key.name));
                    }
                    return new JBossLogger(JBossLoggerContext.this.logContext.getLogger(key.name), key.messageFactory);
                }
            });
        }
    }

    public int hashCode() {
        return Objects.hash(this.logContext, this.externalContext);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JBossLoggerContext)) {
            return false;
        }
        JBossLoggerContext other = (JBossLoggerContext)obj;
        return Objects.equals(this.logContext, other.logContext) && Objects.equals(this.externalContext, other.externalContext);
    }

    private static Map<Key, ExtendedLogger> getLoggers(LogContext context, String name) {
        Logger lmLogger;
        Map appearing;
        Map result = (HashMap)context.getAttachment(name, LOGGER_KEY);
        if (result == null && (appearing = (Map)(lmLogger = context.getLogger(name)).attachIfAbsent(LOGGER_KEY, result = new HashMap())) != null) {
            result = appearing;
        }
        return result;
    }

    private static class Key {
        final String name;
        final MessageFactory messageFactory;

        private Key(String name, MessageFactory messageFactory) {
            this.name = name;
            this.messageFactory = messageFactory;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.messageFactory);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.messageFactory, other.messageFactory);
        }

        public String toString() {
            return "Key(name=" + this.name + ", messageFactory=" + this.messageFactory + ")";
        }
    }
}

