/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Handler;

final class AtomicArray<T, V> {
    private final AtomicReferenceFieldUpdater<T, V[]> updater;
    private final Class<V> componentType;
    private final V[] emptyArray;

    public AtomicArray(AtomicReferenceFieldUpdater<T, V[]> updater, Class<V> componentType) {
        this.updater = updater;
        this.componentType = componentType;
        this.emptyArray = AtomicArray.newInstance(componentType, 0);
    }

    public static <T, V> AtomicArray<T, V> create(AtomicReferenceFieldUpdater<T, V[]> updater, Class<V> componentType) {
        return new AtomicArray<T, V>(updater, componentType);
    }

    public void clear(T instance) {
        this.updater.set(instance, (V[][])this.emptyArray);
    }

    public void set(T instance, V[] value) {
        this.updater.set(instance, (V[][])value);
    }

    public V[] getAndSet(T instance, V[] value) {
        return this.updater.getAndSet(instance, (V[][])value);
    }

    private static <V> V[] copyOf(Class<V> componentType, V[] old, int newLen) {
        V[] target = AtomicArray.newInstance(componentType, newLen);
        System.arraycopy(old, 0, target, 0, Math.min(old.length, newLen));
        return target;
    }

    public void add(T instance, V value) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            newVal = AtomicArray.copyOf(this.componentType, oldVal, oldLen + 1);
            newVal[oldLen] = value;
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
    }

    public boolean addIfAbsent(T instance, V value, boolean identity) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            if (identity || value == null) {
                for (i = 0; i < oldLen; ++i) {
                    if (oldVal[i] != value) continue;
                    return false;
                }
            } else {
                for (i = 0; i < oldLen; ++i) {
                    if (!value.equals(oldVal[i])) continue;
                    return false;
                }
            }
            newVal = AtomicArray.copyOf(this.componentType, oldVal, oldLen + 1);
            newVal[oldLen] = value;
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public boolean remove(T instance, V value, boolean identity) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int oldLen;
            if ((oldLen = (oldVal = updater.get(instance)).length) == 0) {
                return false;
            }
            int index = -1;
            if (identity || value == null) {
                for (i = 0; i < oldLen; ++i) {
                    if (oldVal[i] != value) continue;
                    index = i;
                    break;
                }
            } else {
                for (i = 0; i < oldLen; ++i) {
                    if (!value.equals(oldVal[i])) continue;
                    index = i;
                    break;
                }
            }
            if (index == -1) {
                return false;
            }
            newVal = AtomicArray.newInstance(this.componentType, oldLen - 1);
            System.arraycopy(oldVal, 0, newVal, 0, index);
            System.arraycopy(oldVal, index + 1, newVal, index, oldLen - index - 1);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public int removeAll(T instance, V value, boolean identity) {
        int removeCount;
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int oldLen;
            if ((oldLen = (oldVal = updater.get(instance)).length) == 0) {
                return 0;
            }
            boolean[] removeSlots = new boolean[oldLen];
            removeCount = 0;
            if (identity || value == null) {
                for (i = 0; i < oldLen; ++i) {
                    if (oldVal[i] != value) continue;
                    removeSlots[i] = true;
                    ++removeCount;
                }
            } else {
                for (i = 0; i < oldLen; ++i) {
                    if (!value.equals(oldVal[i])) continue;
                    removeSlots[i] = true;
                    ++removeCount;
                }
            }
            if (removeCount == 0) {
                return 0;
            }
            int newLen = oldLen - removeCount;
            if (newLen == 0) {
                newVal = this.emptyArray;
                continue;
            }
            newVal = AtomicArray.newInstance(this.componentType, newLen);
            int j = 0;
            for (int i = 0; i < oldLen; ++i) {
                if (removeSlots[i]) continue;
                newVal[j++] = oldVal[i];
            }
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return removeCount;
    }

    public void add(T instance, V value, Comparator<? super V> comparator) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            int pos = AtomicArray.insertionPoint(Arrays.binarySearch(oldVal, value, comparator));
            newVal = AtomicArray.newInstance(this.componentType, oldLen + 1);
            System.arraycopy(oldVal, 0, newVal, 0, pos);
            newVal[pos] = value;
            System.arraycopy(oldVal, pos, newVal, pos + 1, oldLen - pos);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
    }

    public boolean addIfAbsent(T instance, V value, Comparator<? super V> comparator) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            int pos = Arrays.binarySearch(oldVal, value, comparator);
            if (pos < 0) {
                return false;
            }
            newVal = AtomicArray.newInstance(this.componentType, oldLen + 1);
            System.arraycopy(oldVal, 0, newVal, 0, pos);
            newVal[pos] = value;
            System.arraycopy(oldVal, pos, newVal, pos + 1, oldLen - pos);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public boolean remove(T instance, V value, Comparator<? super V> comparator) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int oldLen;
            if ((oldLen = (oldVal = updater.get(instance)).length) == 0) {
                return false;
            }
            int pos = Arrays.binarySearch(oldVal, value, comparator);
            if (pos < 0) {
                return false;
            }
            newVal = AtomicArray.newInstance(this.componentType, oldLen - 1);
            System.arraycopy(oldVal, 0, newVal, 0, pos);
            System.arraycopy(oldVal, pos + 1, newVal, pos, oldLen - pos - 1);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public void sort(T instance, Comparator<? super V> comparator) {
        Object[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, Object[][]> updater = this.updater;
        do {
            if ((oldVal = updater.get(instance)).length == 0) {
                return;
            }
            newVal = (Object[])oldVal.clone();
            Arrays.sort(newVal, comparator);
        } while (!updater.compareAndSet(instance, (Object[][])oldVal, (Object[][])newVal));
    }

    private static int insertionPoint(int searchResult) {
        return searchResult > 0 ? searchResult : -(searchResult + 1);
    }

    private static <V> V[] newInstance(Class<V> componentType, int length) {
        if (componentType == Handler.class) {
            return new Handler[length];
        }
        if (componentType == Object.class) {
            return new Object[length];
        }
        return (Object[])Array.newInstance(componentType, length);
    }

    public boolean compareAndSet(T instance, V[] expect, V[] update) {
        return this.updater.compareAndSet(instance, (V[][])expect, (V[][])update);
    }
}

