/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.management;

import org.apache.coyote.RequestInfo;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.web.tomcat.service.management.BaseBean;
import org.jboss.web.tomcat.service.management.IConnector;

@ManagementObject(componentType=@ManagementComponent(type="MBean", subtype="Web"), isRuntime=true, properties=ManagementProperties.EXPLICIT)
public class ConnectorBean
extends BaseBean {
    private IConnector mbeanProxy;

    @ManagementProperty(use={ViewUse.STATISTIC})
    public long getBytesReceived() throws Exception {
        this.initProxy();
        return this.mbeanProxy.getbytesReceived();
    }

    @ManagementProperty(use={ViewUse.STATISTIC})
    public long getBytesSent() throws Exception {
        this.initProxy();
        long sent = this.mbeanProxy.getbytesSent();
        return sent;
    }

    @ManagementProperty(use={ViewUse.STATISTIC})
    public int getErrorCount() throws Exception {
        this.initProxy();
        return this.mbeanProxy.geterrorCount();
    }

    @ManagementProperty(use={ViewUse.STATISTIC})
    public long getMaxTime() throws Exception {
        this.initProxy();
        long maxTime = this.mbeanProxy.getmaxTime();
        return maxTime;
    }

    @ManagementProperty(use={ViewUse.STATISTIC})
    public long getProcessingTime() throws Exception {
        this.initProxy();
        return this.mbeanProxy.getprocessingTime();
    }

    @ManagementProperty(use={ViewUse.STATISTIC})
    public int getRequestCount() throws Exception {
        this.initProxy();
        int count = this.mbeanProxy.getrequestCount();
        return count;
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, ignored=true)
    public RequestInfo[] getRequestProcessors() throws Exception {
        this.initProxy();
        return this.mbeanProxy.getrequestProcessors();
    }

    @ManagementOperation
    public void resetCounters() throws Exception {
        this.initProxy();
        this.mbeanProxy.resetCounters();
    }

    protected void initProxy() {
        if (this.mbeanProxy == null) {
            String name = "http-" + this.getAddress() + "-" + this.getPort();
            super.getNameProps().put("name", name);
            this.mbeanProxy = super.initProxy(IConnector.class);
        }
    }
}

