/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.objectname;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class PatternTEST
extends TestCase {
    public PatternTEST(String s) {
        super(s);
    }

    public void testBasicDomainPattern() {
        String nameArg = "*:key1=val1,key2=val2";
        ObjectName name = this.constructSafely(nameArg);
        PatternTEST.assertTrue((String)"isPattern should be true", (boolean)name.isPattern());
        PatternTEST.assertEquals((String)("toString should be: '" + nameArg + "'"), (String)nameArg, (String)name.toString());
        PatternTEST.assertTrue((String)"isPropertyPattern should be false", (!name.isPropertyPattern() ? 1 : 0) != 0);
        PatternTEST.assertTrue((String)"isDomainPattern should be true", (boolean)name.isDomainPattern());
        PatternTEST.assertEquals((String)"*", (String)name.getDomain());
    }

    public void testBasicDomainPatternExtra() {
        String nameArg = "**:key1=val1,key2=val2";
        ObjectName name = this.constructSafely(nameArg);
        PatternTEST.assertTrue((String)"isPattern should be true", (boolean)name.isPattern());
        PatternTEST.assertEquals((String)("toString should be: '" + nameArg + "'"), (String)nameArg, (String)name.toString());
        PatternTEST.assertTrue((String)"isPropertyPattern should be false", (!name.isPropertyPattern() ? 1 : 0) != 0);
        PatternTEST.assertTrue((String)"isDomainPattern should be true", (boolean)name.isDomainPattern());
        PatternTEST.assertEquals((String)"**", (String)name.getDomain());
    }

    public void testPartialDomainPattern() {
        String nameArg = "*domain:key1=val1,key2=val2";
        ObjectName name = this.constructSafely(nameArg);
        PatternTEST.assertTrue((String)"isPattern should be true", (boolean)name.isPattern());
        PatternTEST.assertEquals((String)("toString should be: '" + nameArg + "'"), (String)nameArg, (String)name.toString());
        PatternTEST.assertTrue((String)"isPropertyPattern should be false", (!name.isPropertyPattern() ? 1 : 0) != 0);
        PatternTEST.assertTrue((String)"isDomainPattern should be true", (boolean)name.isDomainPattern());
        PatternTEST.assertEquals((String)"*domain", (String)name.getDomain());
    }

    public void testHarderPartialDomainPattern() {
        String nameArg = "d*n:key1=val1,key2=val2";
        ObjectName name = this.constructSafely(nameArg);
        PatternTEST.assertTrue((String)"isPattern should be true", (boolean)name.isPattern());
        PatternTEST.assertEquals((String)("toString should be: '" + nameArg + "'"), (String)nameArg, (String)name.toString());
        PatternTEST.assertTrue((String)"isPropertyPattern should be false", (!name.isPropertyPattern() ? 1 : 0) != 0);
        PatternTEST.assertTrue((String)"isDomainPattern should be true", (boolean)name.isDomainPattern());
        PatternTEST.assertEquals((String)"d*n", (String)name.getDomain());
    }

    public void testHarderPartialDomainPatternExtra() {
        String nameArg = "d**n:key1=val1,key2=val2";
        ObjectName name = this.constructSafely(nameArg);
        PatternTEST.assertTrue((String)"isPattern should be true", (boolean)name.isPattern());
        PatternTEST.assertEquals((String)("toString should be: '" + nameArg + "'"), (String)nameArg, (String)name.toString());
        PatternTEST.assertTrue((String)"isPropertyPattern should be false", (!name.isPropertyPattern() ? 1 : 0) != 0);
        PatternTEST.assertTrue((String)"isDomainPattern should be true", (boolean)name.isDomainPattern());
        PatternTEST.assertEquals((String)"d**n", (String)name.getDomain());
    }

    public void testPositionalDomainPattern() {
        String nameArg = "do??in:key1=val1,key2=val2";
        ObjectName name = this.constructSafely(nameArg);
        PatternTEST.assertTrue((String)"isPattern should be true", (boolean)name.isPattern());
        PatternTEST.assertEquals((String)("toString should be: '" + nameArg + "'"), (String)nameArg, (String)name.toString());
        PatternTEST.assertTrue((String)"isPropertyPattern should be false", (!name.isPropertyPattern() ? 1 : 0) != 0);
        PatternTEST.assertTrue((String)"isDomainPattern should be true", (boolean)name.isDomainPattern());
        PatternTEST.assertEquals((String)"do??in", (String)name.getDomain());
    }

    public void testPatternOnly() {
        String nameArg = "*:*";
        ObjectName name = this.constructSafely(nameArg);
        PatternTEST.assertTrue((String)"isPattern should be true", (boolean)name.isPattern());
        PatternTEST.assertTrue((String)"isPropertyPattern should be true", (boolean)name.isPropertyPattern());
        PatternTEST.assertTrue((String)"isDomainPattern should be true", (boolean)name.isDomainPattern());
        PatternTEST.assertEquals((String)"FAILS IN RI", (String)nameArg, (String)name.getCanonicalName());
    }

    public void testKeyPatternOnly() {
        String nameArg = "domain:*";
        ObjectName name = this.constructSafely(nameArg);
        PatternTEST.assertTrue((String)"isPattern should be true", (boolean)name.isPattern());
        PatternTEST.assertTrue((String)"isPropertyPattern should be true", (boolean)name.isPropertyPattern());
        PatternTEST.assertTrue((String)"isDomainPattern should be false", (!name.isDomainPattern() ? 1 : 0) != 0);
        PatternTEST.assertEquals((String)"FAILS IN RI", (String)nameArg, (String)name.getCanonicalName());
        PatternTEST.assertTrue((String)"key properties hash should be zero size", (0 == name.getKeyPropertyList().size() ? 1 : 0) != 0);
    }

    public void testPartialKeyPattern() {
        String nameArg = "domain:key2=val2,*,key1=val1";
        ObjectName name = this.constructSafely(nameArg);
        PatternTEST.assertTrue((String)"isPattern should be true", (boolean)name.isPattern());
        PatternTEST.assertTrue((String)"isPropertyPattern should be true", (boolean)name.isPropertyPattern());
        PatternTEST.assertTrue((String)"isDomainPattern should be false", (!name.isDomainPattern() ? 1 : 0) != 0);
        PatternTEST.assertEquals((String)"FAILS IN RI", (String)"domain:key1=val1,key2=val2,*", (String)name.getCanonicalName());
        PatternTEST.assertTrue((String)"key properties hash should only have 2 elements", (2 == name.getKeyPropertyList().size() ? 1 : 0) != 0);
    }

    public void testEquality_a() {
        ObjectName pat1 = this.constructSafely("domain:*,key=value");
        ObjectName pat2 = this.constructSafely("domain:key=value,*");
        PatternTEST.assertEquals((Object)pat1, (Object)pat2);
    }

    public void testEquality_b() {
        ObjectName pat2;
        ObjectName pat1 = this.constructSafely("do**main:key=value,*");
        PatternTEST.assertTrue((String)".equals() should return false", (!pat1.equals(pat2 = this.constructSafely("do*main:key=value,*")) ? 1 : 0) != 0);
    }

    public void testEquality_c() {
        ObjectName conc = this.constructSafely("domain:key=value");
        ObjectName pat = this.constructSafely("domain:key=value,*");
        PatternTEST.assertTrue((String)"toString() should not match", (!conc.toString().equals(pat.toString()) ? 1 : 0) != 0);
        PatternTEST.assertTrue((String)"equals() should be false", (!conc.equals(pat) ? 1 : 0) != 0);
    }

    private ObjectName constructSafely(String nameArg) {
        ObjectName name = null;
        try {
            name = new ObjectName(nameArg);
        }
        catch (MalformedObjectNameException e) {
            PatternTEST.fail((String)("spurious MalformedObjectNameException on ('" + nameArg + "')"));
        }
        return name;
    }
}

