/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.metadata;

import java.lang.reflect.Method;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.metadata.support.Trivial;

public class MBeanAttributeInfoTEST
extends TestCase {
    public MBeanAttributeInfoTEST(String s) {
        super(s);
    }

    public void testConstructorWithAccessorMethods() {
        try {
            Class<Trivial> c = Trivial.class;
            Method getter = c.getMethod("getSomething", new Class[0]);
            Method setter = c.getMethod("setSomething", String.class);
            MBeanAttributeInfo info = new MBeanAttributeInfo("Something", "a description", getter, setter);
            MBeanAttributeInfoTEST.assertTrue((boolean)info.getDescription().equals("a description"));
            MBeanAttributeInfoTEST.assertTrue((boolean)info.getName().equals("Something"));
            MBeanAttributeInfoTEST.assertTrue((boolean)info.getType().equals("java.lang.String"));
            MBeanAttributeInfoTEST.assertTrue((info.isReadable() ? 1 : 0) != 0);
            MBeanAttributeInfoTEST.assertTrue((info.isWritable() ? 1 : 0) != 0);
            MBeanAttributeInfoTEST.assertTrue((!info.isIs() ? 1 : 0) != 0);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanAttributeInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testConstructorWithMisplacedAccessorMethods() {
        try {
            Class<Trivial> c = Trivial.class;
            Method getter = c.getMethod("getSomething", new Class[0]);
            Method setter = c.getMethod("setSomething", String.class);
            new MBeanAttributeInfo("Something", "a description", setter, getter);
            MBeanAttributeInfoTEST.fail((String)"Introspection exception should have been thrown.");
        }
        catch (IntrospectionException e) {
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanAttributeInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testConstructorWithInvalidGetterMethod() {
        try {
            Class<Trivial> c = Trivial.class;
            Method getter = c.getMethod("getSomethingInvalid", Object.class);
            Method setter = c.getMethod("setSomethingInvalid", String.class);
            new MBeanAttributeInfo("Something", "a description", getter, setter);
            MBeanAttributeInfoTEST.fail((String)"Introspection exception should have been thrown.");
        }
        catch (IntrospectionException e) {
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanAttributeInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testConstructorWithInvalidGetterMethod2() {
        try {
            Class<Trivial> c = Trivial.class;
            Method getter = c.getMethod("getSomethingInvalid2", new Class[0]);
            Method setter = c.getMethod("setSomethingInvalid2", String.class);
            new MBeanAttributeInfo("Something", "a description", getter, setter);
            MBeanAttributeInfoTEST.fail((String)"Introspection exception should have been thrown.");
        }
        catch (IntrospectionException e) {
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanAttributeInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testConstructorWithNonBooleanIsIs() throws Exception {
        try {
            new MBeanAttributeInfo("name", "type", "description", true, true, true);
        }
        catch (Exception e) {
            return;
        }
        MBeanAttributeInfoTEST.fail((String)"isIs is only allowed for boolean types");
    }

    public void testConstructorWithPrimitiveBooleanIsIs() throws Exception {
        new MBeanAttributeInfo("name", Boolean.TYPE.getName(), "description", true, true, true);
    }

    public void testConstructorWithObjectBooleanIsIs() throws Exception {
        new MBeanAttributeInfo("name", Boolean.class.getName(), "description", true, true, true);
    }

    public void testHashCode() throws Exception {
        MBeanAttributeInfo info1 = new MBeanAttributeInfo("name", "type", "description", true, true, false);
        MBeanAttributeInfo info2 = new MBeanAttributeInfo("name", "type", "description", true, true, false);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with the same hashcode are equal", (info1.hashCode() == info2.hashCode() ? 1 : 0) != 0);
    }

    public void testEquals() throws Exception {
        MBeanAttributeInfo info = new MBeanAttributeInfo("name", "type", "description", true, true, false);
        MBeanAttributeInfoTEST.assertTrue((String)"Null should not be equal", (!info.equals(null) ? 1 : 0) != 0);
        MBeanAttributeInfoTEST.assertTrue((String)"Only MBeanAttributeInfo should be equal", (!info.equals(new Object()) ? 1 : 0) != 0);
        MBeanAttributeInfo info2 = new MBeanAttributeInfo("name", "type", "description", true, true, false);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances of the same data are equal", (boolean)info.equals(info2));
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances of the same data are equal", (boolean)info2.equals(info));
        info2 = new MBeanAttributeInfo("name2", "type", "description", true, true, false);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanAttributeInfo("name", "type2", "description", true, true, false);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different types are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different types are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanAttributeInfo("name", "type", "description2", true, true, false);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different descriptions are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different descritpions are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanAttributeInfo("name", "type", "description", false, true, false);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different readables are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different readables are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanAttributeInfo("name", "type", "description", true, false, false);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different writables are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different writables are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanAttributeInfo("name", Boolean.TYPE.getName(), "description", true, true, true);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different isIs are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanAttributeInfoTEST.assertTrue((String)"Different instances with different isIs are not equal", (!info2.equals(info) ? 1 : 0) != 0);
    }
}

