/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.notification;

import java.util.ArrayList;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilterSupport;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.notification.support.Listener;

public class NotificationBroadcasterSupportTestCase
extends TestCase {
    private ArrayList sent = new ArrayList();
    private long sequence = 0L;
    private static final String DEFAULT_TYPE = "DefaultType";
    private static final String ANOTHER_TYPE = "AnotherType";
    private static final ArrayList EMPTY = new ArrayList();

    public NotificationBroadcasterSupportTestCase(String s) {
        super(s);
    }

    public void testAddNotificationListener() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        broadcaster.addNotificationListener(new Listener(), null, null);
        broadcaster.addNotificationListener(new Listener(), new NotificationFilterSupport(), null);
        broadcaster.addNotificationListener(new Listener(), null, new Object());
        broadcaster.addNotificationListener(new Listener(), new NotificationFilterSupport(), new Object());
    }

    public void testAddNotificationListenerErrors() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        boolean caught = false;
        try {
            broadcaster.addNotificationListener(null, null, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected IllegalArgumentException for null listener", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(null, new NotificationFilterSupport(), null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected IllegalArgumentException for null listener", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(null, null, new Object());
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected IllegalArgumentException for null listener", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(null, new NotificationFilterSupport(), new Object());
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected IllegalArgumentException for null listener", (boolean)caught);
    }

    public void testNotificationWithNoListeners() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        this.clear();
        this.createNotification(broadcaster);
    }

    public void testSimpleNotification() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster.addNotificationListener(listener, null, null);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(this.sent, this.received(listener, null));
    }

    public void testSimpleFilteredNotification() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, null);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(this.apply(this.sent, filter), this.received(listener, null));
    }

    public void testSimpleFilteredOutNotification() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.disableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, null);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(this.apply(this.sent, filter), this.received(listener, null));
    }

    public void testSimpleNotificationWithHandback() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        broadcaster.addNotificationListener(listener, null, handback);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(this.sent, this.received(listener, handback));
        this.compare(EMPTY, this.received(listener, null));
    }

    public void testTwoNotifications() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster.addNotificationListener(listener, null, null);
        this.clear();
        this.createNotification(broadcaster);
        this.createNotification(broadcaster);
        this.compare(this.sent, this.received(listener, null));
    }

    public void testTwoNotificationsWithDifferentTypes() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        filter.enableType(ANOTHER_TYPE);
        broadcaster.addNotificationListener(listener, filter, null);
        this.clear();
        this.createNotification(broadcaster);
        this.createNotification(broadcaster, ANOTHER_TYPE);
        this.compare(this.apply(this.sent, filter), this.received(listener, null));
    }

    public void testTwoNotificationsWithDifferentTypesOneFilteredOut() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, null);
        this.clear();
        this.createNotification(broadcaster);
        this.createNotification(broadcaster, ANOTHER_TYPE);
        this.compare(this.apply(this.sent, filter), this.received(listener, null));
    }

    public void testTwoListeners() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener1 = new Listener();
        broadcaster.addNotificationListener(listener1, null, null);
        Listener listener2 = new Listener();
        broadcaster.addNotificationListener(listener2, null, null);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(this.sent, this.received(listener1, null));
        this.compare(this.sent, this.received(listener2, null));
    }

    public void testOneListenerRegisteredTwice() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster.addNotificationListener(listener, null, null);
        broadcaster.addNotificationListener(listener, null, null);
        this.clear();
        this.createNotification(broadcaster);
        ArrayList copySent = new ArrayList(this.sent);
        copySent.addAll(this.sent);
        this.compare(copySent, this.received(listener, null));
    }

    public void testOneListenerRegisteredTwiceOneFilteredOut() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster.addNotificationListener(listener, null, null);
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.disableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, null);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(this.sent, this.received(listener, null));
    }

    public void testOneListenerRegisteredWithDifferentHandbacks() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback1 = new Object();
        broadcaster.addNotificationListener(listener, null, handback1);
        Object handback2 = new Object();
        broadcaster.addNotificationListener(listener, null, handback2);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(this.sent, this.received(listener, handback1));
        this.compare(this.sent, this.received(listener, handback2));
        this.compare(EMPTY, this.received(listener, null));
    }

    public void testOneListenerRegisteredWithDifferentHandbacksOneFilteredOut() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback1 = new Object();
        broadcaster.addNotificationListener(listener, null, handback1);
        Object handback2 = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.disableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, handback2);
        this.clear();
        this.createNotification(broadcaster);
        this.compare(this.sent, this.received(listener, handback1));
        this.compare(this.apply(this.sent, filter), this.received(listener, handback2));
        this.compare(EMPTY, this.received(listener, null));
    }

    public void testOneListenerRegisteredWithTwoBroadcasters() throws Exception {
        NotificationBroadcasterSupport broadcaster1 = new NotificationBroadcasterSupport();
        NotificationBroadcasterSupport broadcaster2 = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster1.addNotificationListener(listener, null, null);
        broadcaster2.addNotificationListener(listener, null, null);
        this.createNotification(broadcaster1);
        this.createNotification(broadcaster2);
        this.compare(this.sent, this.received(listener, null));
    }

    public void testRemoveListener() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster.addNotificationListener(listener, null, null);
        broadcaster.removeNotificationListener(listener);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
    }

    public void testRegisteredTwiceRemoveListener() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster.addNotificationListener(listener, null, null);
        broadcaster.addNotificationListener(listener, null, null);
        broadcaster.removeNotificationListener(listener);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
    }

    public void testRegisteredWithFilterRemoveListener() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, null);
        broadcaster.removeNotificationListener(listener);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
    }

    public void testRegisteredWithHandbackRemoveListener() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        broadcaster.addNotificationListener(listener, null, handback);
        broadcaster.removeNotificationListener(listener);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        this.compare(EMPTY, this.received(listener, handback));
    }

    public void testRegisteredWithFilterHandbackRemoveListener() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.removeNotificationListener(listener);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        this.compare(EMPTY, this.received(listener, handback));
    }

    public void testRegisterRemoveListenerRegister() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster.addNotificationListener(listener, null, null);
        broadcaster.removeNotificationListener(listener);
        broadcaster.addNotificationListener(listener, null, null);
        this.createNotification(broadcaster);
        this.compare(this.sent, this.received(listener, null));
    }

    public void testRemoveListenerErrors() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        boolean caught = false;
        try {
            broadcaster.removeNotificationListener(null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for null listener", (boolean)caught);
        caught = false;
        try {
            broadcaster.removeNotificationListener(listener);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener never added", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, null, null);
            broadcaster.removeNotificationListener(listener);
            broadcaster.removeNotificationListener(listener);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove twice", (boolean)caught);
    }

    public void testRemoveTripletListenerOnly() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        broadcaster.addNotificationListener(listener, null, null);
        broadcaster.removeNotificationListener(listener, null, null);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
    }

    public void testRemoveTripletListenerFilter() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, null);
        broadcaster.removeNotificationListener(listener, filter, null);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
    }

    public void testRemoveTripletListenerHandback() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        broadcaster.addNotificationListener(listener, null, handback);
        broadcaster.removeNotificationListener(listener, null, handback);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        this.compare(EMPTY, this.received(listener, handback));
    }

    public void testRemoveTripletListenerFilterHandback() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.removeNotificationListener(listener, filter, handback);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        this.compare(EMPTY, this.received(listener, handback));
    }

    public void testRegisterTwiceRemoveOnceTriplet() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.removeNotificationListener(listener, filter, handback);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        this.compare(this.sent, this.received(listener, handback));
    }

    public void testRegisterTwiceRemoveTwiceTriplet() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.removeNotificationListener(listener, filter, handback);
        broadcaster.removeNotificationListener(listener, filter, handback);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        this.compare(EMPTY, this.received(listener, handback));
    }

    public void testRegisterTwoRemoveOneTripletListener() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.addNotificationListener(listener, null, null);
        broadcaster.removeNotificationListener(listener, null, null);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        this.compare(this.sent, this.received(listener, handback));
    }

    public void testRegisterTwoRemoveOneTripletListenerFilter() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.addNotificationListener(listener, filter, null);
        broadcaster.removeNotificationListener(listener, filter, null);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        this.compare(this.sent, this.received(listener, handback));
    }

    public void testRegisterTwoRemoveOneTripletListenerHandback() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.addNotificationListener(listener, null, handback);
        broadcaster.removeNotificationListener(listener, null, handback);
        this.createNotification(broadcaster);
        this.compare(EMPTY, this.received(listener, null));
        this.compare(this.sent, this.received(listener, handback));
    }

    public void testRegisterTwoRemoveOneTripletListenerFilterHandback() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Listener listener = new Listener();
        Object handback = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        broadcaster.addNotificationListener(listener, null, null);
        broadcaster.addNotificationListener(listener, filter, handback);
        broadcaster.removeNotificationListener(listener, filter, handback);
        this.createNotification(broadcaster);
        this.compare(this.sent, this.received(listener, null));
        this.compare(EMPTY, this.received(listener, handback));
    }

    public void testRemoveTripletErrors() throws Exception {
        NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
        Object handback = new Object();
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(DEFAULT_TYPE);
        Listener listener = new Listener();
        boolean caught = false;
        try {
            broadcaster.removeNotificationListener(null, null, null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for null listener", (boolean)caught);
        caught = false;
        try {
            broadcaster.removeNotificationListener(listener, null, null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener never added", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, null, null);
            broadcaster.removeNotificationListener(listener, null, null);
            broadcaster.removeNotificationListener(listener, null, null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove twice", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, filter, null);
            broadcaster.removeNotificationListener(listener, new NotificationFilterSupport(), null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, filter, null);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for wrong filter", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, null, handback);
            broadcaster.removeNotificationListener(listener, null, new Object());
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, null, handback);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for wrong handback", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, filter, handback);
            broadcaster.removeNotificationListener(listener, new NotificationFilterSupport(), new Object());
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, filter, handback);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for wrong filter and handback", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, filter, handback);
            broadcaster.removeNotificationListener(listener, null, null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, filter, handback);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 1", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, filter, handback);
            broadcaster.removeNotificationListener(listener, filter, null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, filter, handback);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 2", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, filter, handback);
            broadcaster.removeNotificationListener(listener, null, handback);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, filter, handback);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 3", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, filter, null);
            broadcaster.removeNotificationListener(listener, null, null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, filter, null);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 4", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, filter, null);
            broadcaster.removeNotificationListener(listener, null, handback);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, filter, null);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 5", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, filter, null);
            broadcaster.removeNotificationListener(listener, filter, handback);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, filter, null);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 6", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, null, handback);
            broadcaster.removeNotificationListener(listener, null, null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, null, handback);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 7", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, null, handback);
            broadcaster.removeNotificationListener(listener, filter, null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, null, handback);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 8", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, null, handback);
            broadcaster.removeNotificationListener(listener, filter, handback);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, null, handback);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 9", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, null, null);
            broadcaster.removeNotificationListener(listener, filter, null);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, null, null);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 10", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, null, null);
            broadcaster.removeNotificationListener(listener, null, handback);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, null, null);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 11", (boolean)caught);
        caught = false;
        try {
            broadcaster.addNotificationListener(listener, null, null);
            broadcaster.removeNotificationListener(listener, filter, handback);
        }
        catch (ListenerNotFoundException e) {
            caught = true;
            broadcaster.removeNotificationListener(listener, null, null);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)"Expected ListenerNotFoundException for listener remove with wrong triplet 12", (boolean)caught);
    }

    private void createNotification(NotificationBroadcasterSupport broadcaster) {
        this.createNotification(broadcaster, DEFAULT_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNotification(NotificationBroadcasterSupport broadcaster, String type) {
        NotificationBroadcasterSupportTestCase notificationBroadcasterSupportTestCase = this;
        synchronized (notificationBroadcasterSupportTestCase) {
            ++this.sequence;
        }
        Notification notification = new Notification(type, broadcaster, this.sequence);
        this.sent.add(notification);
        broadcaster.sendNotification(notification);
    }

    private void clear() {
        this.sent.clear();
    }

    private ArrayList apply(ArrayList sent, NotificationFilterSupport filter) {
        ArrayList<Notification> result = new ArrayList<Notification>();
        for (Notification notification : sent) {
            if (!filter.isNotificationEnabled(notification)) continue;
            result.add(notification);
        }
        return result;
    }

    private ArrayList received(Listener listener, Object object) {
        ArrayList result = (ArrayList)listener.notifications.get(object);
        if (result == null) {
            result = EMPTY;
        }
        return result;
    }

    private void compare(ArrayList passedSent, ArrayList passedReceived) throws Exception {
        ArrayList sent = new ArrayList(passedSent);
        ArrayList received = new ArrayList(passedReceived);
        for (Notification notification : sent) {
            boolean found = received.remove(notification);
            NotificationBroadcasterSupportTestCase.assertTrue((String)("Expected notification " + notification), (boolean)found);
        }
        NotificationBroadcasterSupportTestCase.assertTrue((String)("Didn't expect notification(s) " + received), (boolean)received.isEmpty());
    }
}

