/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.modelmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import junit.framework.TestCase;

public class DescriptorTEST
extends TestCase {
    public DescriptorTEST(String s) {
        super(s);
    }

    public void testDefaultConstructor() throws Exception {
        DescriptorSupport descriptor = new DescriptorSupport();
        DescriptorTEST.assertTrue((String)"Should be empty", (descriptor.getFields().length == 0 ? 1 : 0) != 0);
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
    }

    public void testSizeConstructor() throws Exception {
        DescriptorSupport descriptor = new DescriptorSupport(100);
        DescriptorTEST.assertTrue((String)"Should be empty", (descriptor.getFields().length == 0 ? 1 : 0) != 0);
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
        boolean caught = false;
        try {
            descriptor = new DescriptorSupport(-1);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for a negative size", (boolean)caught);
    }

    public void testCopyConstructor() throws Exception {
        DescriptorSupport descriptor = new DescriptorSupport((DescriptorSupport)null);
        DescriptorTEST.assertTrue((String)"Should be empty", (descriptor.getFields().length == 0 ? 1 : 0) != 0);
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
        descriptor = new DescriptorSupport(descriptor);
        DescriptorTEST.assertTrue((String)"Should be empty", (descriptor.getFields().length == 0 ? 1 : 0) != 0);
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
        descriptor.setField("name", "testName");
        descriptor.setField("descriptorType", "testType");
        descriptor = new DescriptorSupport(descriptor);
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        DescriptorTEST.assertTrue((String)"Should be valid", (boolean)descriptor.isValid());
    }

    public void testNamesValuesConstructor() throws Exception {
        String[] names = new String[]{"name", "descriptorType"};
        Object[] values = new Object[]{"testName", "testType"};
        DescriptorSupport descriptor = new DescriptorSupport(names, values);
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        DescriptorTEST.assertTrue((String)"Should be valid", (boolean)descriptor.isValid());
        descriptor = new DescriptorSupport(new String[0], new Object[0]);
        DescriptorTEST.assertTrue((String)"Should be empty", (descriptor.getFields().length == 0 ? 1 : 0) != 0);
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
        boolean caught = false;
        try {
            descriptor = new DescriptorSupport(null, null);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null names and values", (boolean)caught);
        caught = false;
        try {
            descriptor = new DescriptorSupport(null, values);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null names", (boolean)caught);
        caught = false;
        try {
            descriptor = new DescriptorSupport(names, null);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null values", (boolean)caught);
        Object[] tooManyValues = new Object[]{"testName", "testType", "tooMany"};
        caught = false;
        try {
            descriptor = new DescriptorSupport(names, tooManyValues);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for too many values", (boolean)caught);
        Object[] tooFewValues = new Object[]{"testName"};
        caught = false;
        try {
            descriptor = new DescriptorSupport(names, tooFewValues);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for too few values", (boolean)caught);
        String[] nullName = new String[]{"name", null};
        caught = false;
        try {
            descriptor = new DescriptorSupport(nullName, values);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null name", (boolean)caught);
        String[] emptyName = new String[]{"name", ""};
        caught = false;
        try {
            descriptor = new DescriptorSupport(emptyName, values);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for empty name ", (boolean)caught);
        String[] notEmptyName = new String[]{"name", " "};
        descriptor = new DescriptorSupport(notEmptyName, values);
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue(" "));
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
        names = new String[]{"name", "descriptorType", "another"};
        values = new Object[]{"testName", "testType", null};
        descriptor = new DescriptorSupport(names, values);
        DescriptorTEST.assertTrue((String)"Should be three fields", (descriptor.getFields().length == 3 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        DescriptorTEST.assertTrue((String)"another should be null", (descriptor.getFieldValue("another") == null ? 1 : 0) != 0);
        DescriptorTEST.assertTrue((String)"Should be valid", (boolean)descriptor.isValid());
    }

    public void testNameEqualsValueConstructor() throws Exception {
        String[] fields = new String[]{"name=testName", "descriptorType=testType"};
        DescriptorSupport descriptor = new DescriptorSupport(fields);
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        DescriptorTEST.assertTrue((String)"Should be valid", (boolean)descriptor.isValid());
        descriptor = new DescriptorSupport((String[])null);
        DescriptorTEST.assertTrue((String)"Should be empty", (descriptor.getFields().length == 0 ? 1 : 0) != 0);
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
        descriptor = new DescriptorSupport(new String[0]);
        DescriptorTEST.assertTrue((String)"Should be empty", (descriptor.getFields().length == 0 ? 1 : 0) != 0);
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
        String[] nullName = new String[]{"name=testName", "=rubbish"};
        boolean caught = false;
        try {
            descriptor = new DescriptorSupport(nullName);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for '=rubbish'", (boolean)caught);
        String[] notEmptyName = new String[]{"name=testName", " =rubbish"};
        descriptor = new DescriptorSupport(notEmptyName);
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"rubbish", (Object)descriptor.getFieldValue(" "));
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
    }

    public void testNameEqualsValueConstructorError() throws Exception {
        try {
            String[] fields = new String[]{"name=testName", "descriptorType=testType", "another="};
            DescriptorSupport descriptor = new DescriptorSupport(fields);
            DescriptorTEST.assertTrue((String)"Should be three fields", (descriptor.getFields().length == 3 ? 1 : 0) != 0);
            DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
            DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
            DescriptorTEST.assertTrue((String)"another should be null", (descriptor.getFieldValue("another") == null ? 1 : 0) != 0);
            DescriptorTEST.assertTrue((String)"Should be valid", (boolean)descriptor.isValid());
        }
        catch (Exception e) {
            DescriptorTEST.fail((String)("FAILS IN RI: 'another=' should be valid according to the javadoc " + e.toString()));
        }
    }

    public void testGetFieldValue() throws Exception {
        String[] fields = new String[]{"name=testName", "descriptorType=testType"};
        DescriptorSupport descriptor = new DescriptorSupport(fields);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertTrue((String)"Field names are not case sensitive", (boolean)"testName".equals(descriptor.getFieldValue("NAME")));
        DescriptorTEST.assertTrue((String)"Non existent field should be null", (descriptor.getFieldValue("nonExistent") == null ? 1 : 0) != 0);
        boolean caught = false;
        try {
            descriptor.getFieldValue(null);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null name", (boolean)caught);
        caught = false;
        try {
            descriptor.getFieldValue("");
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for empty name", (boolean)caught);
        DescriptorTEST.assertTrue((String)"Blank field name is allowed", (descriptor.getFieldValue(" ") == null ? 1 : 0) != 0);
    }

    public void testSetFieldValue() throws Exception {
        String[] fields = new String[]{"name=testName", "descriptorType=testType"};
        DescriptorSupport descriptor = new DescriptorSupport(fields);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        descriptor.setField("name", "newName");
        DescriptorTEST.assertEquals((Object)"newName", (Object)descriptor.getFieldValue("name"));
        descriptor.setField("NAME", "newNAME");
        DescriptorTEST.assertEquals((Object)"newNAME", (Object)descriptor.getFieldValue("name"));
        boolean caught = false;
        try {
            descriptor.setField(null, "null");
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null name", (boolean)caught);
        caught = false;
        try {
            descriptor.setField("", "empty");
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for empty name", (boolean)caught);
        descriptor.setField(" ", "blank");
        DescriptorTEST.assertEquals((Object)"blank", (Object)descriptor.getFieldValue(" "));
        descriptor.setField("newField", "newValue");
        DescriptorTEST.assertEquals((Object)"newValue", (Object)descriptor.getFieldValue("newField"));
    }

    public void testGetFields() throws Exception {
        String[] fields = new String[]{"name=testName", "descriptorType=testType"};
        DescriptorSupport descriptor = new DescriptorSupport(fields);
        String[] getFields = descriptor.getFields();
        this.compareFields(fields, getFields);
    }

    public void testGetFieldNames() throws Exception {
        String[] fields = new String[]{"name=testName", "descriptorType=testType"};
        DescriptorSupport descriptor = new DescriptorSupport(fields);
        String[] names = descriptor.getFieldNames();
        this.compareFieldNames(fields, names);
    }

    public void testGetFieldValues() throws Exception {
        String[] names = new String[]{"name", "descriptorType"};
        Object[] values = new String[]{"testName", "testType"};
        DescriptorSupport descriptor = new DescriptorSupport(names, values);
        Object[] result = descriptor.getFieldValues(null);
        this.compareFieldValuesUnsorted(values, result);
        result = descriptor.getFieldValues(new String[0]);
        this.compareFieldValues(new Object[0], result);
        result = descriptor.getFieldValues(names);
        this.compareFieldValues(values, result);
        result = descriptor.getFieldValues("name");
        this.compareFieldValues(new Object[]{"testName"}, result);
        result = descriptor.getFieldValues("descriptorType", "name");
        this.compareFieldValues(new Object[]{"testType", "testName"}, result);
        result = descriptor.getFieldValues("NAME");
        this.compareFieldValues(new Object[]{"testName"}, result);
        result = descriptor.getFieldValues(new String[]{null});
        this.compareFieldValues(new Object[]{null}, result);
        result = descriptor.getFieldValues("");
        this.compareFieldValues(new Object[]{null}, result);
    }

    public void testSetFieldValues() throws Exception {
        DescriptorSupport descriptor = new DescriptorSupport();
        String[] names = new String[]{"name", "descriptorType"};
        Object[] values = new Object[]{"testName", "testType"};
        descriptor.setFields(names, values);
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        DescriptorTEST.assertTrue((String)"Should be valid", (boolean)descriptor.isValid());
        descriptor = new DescriptorSupport();
        descriptor.setFields(new String[0], new Object[0]);
        DescriptorTEST.assertTrue((String)"Should be empty", (descriptor.getFields().length == 0 ? 1 : 0) != 0);
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
        boolean caught = false;
        try {
            descriptor = new DescriptorSupport();
            descriptor.setFields(null, null);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null names and values", (boolean)caught);
        caught = false;
        try {
            descriptor = new DescriptorSupport();
            descriptor.setFields(null, values);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null names", (boolean)caught);
        caught = false;
        try {
            descriptor = new DescriptorSupport();
            descriptor.setFields(names, null);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null values", (boolean)caught);
        Object[] tooManyValues = new Object[]{"testName", "testType", "tooMany"};
        caught = false;
        try {
            descriptor = new DescriptorSupport();
            descriptor.setFields(names, tooManyValues);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for too many values", (boolean)caught);
        Object[] tooFewValues = new Object[]{"testName"};
        caught = false;
        try {
            descriptor = new DescriptorSupport();
            descriptor.setFields(names, tooFewValues);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for too few values", (boolean)caught);
        String[] nullName = new String[]{"name", null};
        caught = false;
        try {
            descriptor = new DescriptorSupport();
            descriptor.setFields(nullName, values);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for null name", (boolean)caught);
        String[] emptyName = new String[]{"name", ""};
        caught = false;
        try {
            descriptor = new DescriptorSupport();
            descriptor.setFields(emptyName, values);
        }
        catch (RuntimeOperationsException e) {
            caught = true;
        }
        DescriptorTEST.assertTrue((String)"Expected an exception for empty name ", (boolean)caught);
        String[] notEmptyName = new String[]{"name", " "};
        descriptor = new DescriptorSupport();
        descriptor.setFields(notEmptyName, values);
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue(" "));
        DescriptorTEST.assertFalse((String)"Should not be valid", (boolean)descriptor.isValid());
        names = new String[]{"name", "descriptorType", "another"};
        values = new Object[]{"testName", "testType", null};
        descriptor = new DescriptorSupport();
        descriptor.setFields(names, values);
        DescriptorTEST.assertTrue((String)"Should be three fields", (descriptor.getFields().length == 3 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        DescriptorTEST.assertTrue((String)"another should be null", (descriptor.getFieldValue("another") == null ? 1 : 0) != 0);
        DescriptorTEST.assertTrue((String)"Should be valid", (boolean)descriptor.isValid());
    }

    public void testClone() throws Exception {
        String[] names = new String[]{"name", "descriptorType"};
        Object[] values = new Object[]{"testName", "testType"};
        DescriptorSupport descriptor = new DescriptorSupport(names, values);
        DescriptorSupport clone = (DescriptorSupport)descriptor.clone();
        this.compareFields(descriptor.getFields(), clone.getFields());
    }

    public void testRemove() throws Exception {
        String[] names = new String[]{"name", "descriptorType"};
        Object[] values = new Object[]{"testName", "testType"};
        DescriptorSupport descriptor = new DescriptorSupport(names, values);
        descriptor.removeField("name");
        DescriptorTEST.assertTrue((String)"Should be one field", (descriptor.getFields().length == 1 ? 1 : 0) != 0);
        DescriptorTEST.assertTrue((String)"name should not be present", (descriptor.getFieldValue("name") == null ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        descriptor = new DescriptorSupport(names, values);
        descriptor.removeField("NAME");
        DescriptorTEST.assertTrue((String)"Should be one field", (descriptor.getFields().length == 1 ? 1 : 0) != 0);
        DescriptorTEST.assertTrue((String)"name should not be present", (descriptor.getFieldValue("name") == null ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        descriptor = new DescriptorSupport(names, values);
        descriptor.removeField("notPresent");
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        descriptor.removeField(null);
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
        descriptor.removeField("");
        DescriptorTEST.assertTrue((String)"Should be two fields", (descriptor.getFields().length == 2 ? 1 : 0) != 0);
        DescriptorTEST.assertEquals((Object)"testName", (Object)descriptor.getFieldValue("name"));
        DescriptorTEST.assertEquals((Object)"testType", (Object)descriptor.getFieldValue("descriptorType"));
    }

    public void testIsValidMandatory() throws Exception {
        String[] names = new String[]{"name", "descriptorType"};
        Object[] values = new Object[]{"testName", "testType"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType"};
        values = new Object[]{null, "testType"};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType"};
        values = new Object[]{"", "testType"};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType"};
        values = new Object[]{"testName", null};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType"};
        values = new Object[]{"testName", ""};
        this.validate(names, values, false);
    }

    public void testIsValidRole() throws Exception {
        this.doTestString("role", "operation");
    }

    public void testIsValidGetMethod() throws Exception {
        this.doTestString("getMethod", "getSomething");
    }

    public void testIsValidSetMethod() throws Exception {
        this.doTestString("setMethod", "setSomething");
    }

    public void testIsValidPersistPeriod() throws Exception {
        this.doTestInteger("persistPeriod");
    }

    public void testIsValidCurrencyTimeLimit() throws Exception {
        this.doTestInteger("currencyTimeLimit");
    }

    public void testIsValidLastUpdateTimeStamp() throws Exception {
        this.doTestInteger("lastUpdatedTimeStamp");
    }

    public void testIsValidLog() throws Exception {
        String[] names = new String[]{"name", "descriptorType", "log"};
        Object[] values = new Object[]{"testName", "testType", "true"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", "false"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", "t"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", "f"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", "TRUE"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", "FALSE"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", "T"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", "F"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", null};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", ""};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "log"};
        values = new Object[]{"testName", "testType", "rubbish"};
        this.validate(names, values, false);
    }

    public void testIsValidVisibility() throws Exception {
        String[] names = new String[]{"name", "descriptorType", "visibility"};
        Object[] values = new Object[]{"testName", "testType", "1"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", "2"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", "3"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", "4"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", "0"};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", "5"};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", new Integer(1)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", new Integer(2)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", new Integer(3)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", new Integer(4)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", new Integer(0)};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", new Integer(6)};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", null};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "visibility"};
        values = new Object[]{"testName", "testType", ""};
        this.validate(names, values, false);
    }

    public void testIsValidSeverity() throws Exception {
        String[] names = new String[]{"name", "descriptorType", "severity"};
        Object[] values = new Object[]{"testName", "testType", "1"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", "2"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", "3"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", "4"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", "5"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", new Integer(1)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", new Integer(2)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", new Integer(3)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", new Integer(4)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", new Integer(5)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", null};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", ""};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", "0"};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", "7"};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", new Integer(0)};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "severity"};
        values = new Object[]{"testName", "testType", new Integer(7)};
        this.validate(names, values, false);
    }

    public void testIsValidError() throws Exception {
        try {
            String[] names = new String[]{"name", "descriptorType", "severity"};
            Object[] values = new Object[]{"testName", "testType", "6"};
            this.validate(names, values, true);
            names = new String[]{"name", "descriptorType", "severity"};
            values = new Object[]{"testName", "testType", new Integer(6)};
            this.validate(names, values, true);
        }
        catch (Exception e) {
            DescriptorTEST.fail((String)"FAILS IN RI: javadoc and spec are inconsistent on whether severity=6 is valid");
        }
    }

    public void testIsValidPersistPolicy() throws Exception {
        String[] names = new String[]{"name", "descriptorType", "persistPolicy"};
        Object[] values = new Object[]{"testName", "testType", "onUpdate"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "persistPolicy"};
        values = new Object[]{"testName", "testType", "noMoreOftenThan"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "persistPolicy"};
        values = new Object[]{"testName", "testType", "never"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "persistPolicy"};
        values = new Object[]{"testName", "testType", "onTimer"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", "persistPolicy"};
        values = new Object[]{"testName", "testType", null};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "persistPolicy"};
        values = new Object[]{"testName", "testType", ""};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", "persistPolicy"};
        values = new Object[]{"testName", "testType", "rubbish"};
        this.validate(names, values, false);
    }

    public void testSerialization() throws Exception {
        String[] names = new String[]{"name", "descriptorType"};
        Object[] values = new Object[]{"testName", "testType"};
        DescriptorSupport descriptor = new DescriptorSupport(names, values);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(descriptor);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        this.compareFields(descriptor.getFields(), ((DescriptorSupport)result).getFields());
    }

    private void doTestString(String field, String value) throws Exception {
        String[] names = new String[]{"name", "descriptorType", field};
        Object[] values = new Object[]{"testName", "testType", value};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", null};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", ""};
        this.validate(names, values, false);
    }

    public void doTestInteger(String field) {
        String[] names = new String[]{"name", "descriptorType", field};
        Object[] values = new Object[]{"testName", "testType", "0"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", "-1"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", "100"};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", "-2"};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", null};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", ""};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", "rubbish"};
        this.validate(names, values, false);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", new Integer(0)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", new Integer(-1)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", new Integer(100)};
        this.validate(names, values, true);
        names = new String[]{"name", "descriptorType", field};
        values = new Object[]{"testName", "testType", new Integer(-2)};
        this.validate(names, values, false);
    }

    private void validate(String[] names, Object[] values, boolean valid) {
        DescriptorSupport descriptor = null;
        RuntimeOperationsException caught = null;
        boolean descriptorValid = false;
        try {
            descriptor = new DescriptorSupport(names, values);
            descriptorValid = descriptor.isValid();
        }
        catch (RuntimeOperationsException e) {
            caught = e;
        }
        if (valid && caught != null) {
            throw caught;
        }
        DescriptorTEST.assertEquals((String)("Expected " + valid + " for new Descriptor(String[], String[]) names=" + Arrays.asList(names) + " values=" + Arrays.asList(values)), (boolean)valid, (boolean)descriptorValid);
        caught = null;
        descriptorValid = false;
        try {
            String[] fields = new String[names.length];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = values[i] == null ? names[i] + "=" : names[i] + "=" + values[i].toString();
            }
            descriptor = new DescriptorSupport(names, values);
            descriptorValid = descriptor.isValid();
        }
        catch (RuntimeOperationsException e) {
            caught = e;
        }
        if (valid && caught != null) {
            throw caught;
        }
        DescriptorTEST.assertEquals((String)("Expected " + valid + " for new Descriptor(String[], String[]) names=" + Arrays.asList(names) + " values=" + Arrays.asList(values)), (boolean)valid, (boolean)descriptorValid);
        caught = null;
        descriptorValid = false;
        try {
            descriptor = new DescriptorSupport();
            for (int i = 0; i < names.length; ++i) {
                descriptor.setField(names[i], values[i]);
            }
            descriptorValid = descriptor.isValid();
        }
        catch (RuntimeOperationsException e) {
            caught = e;
        }
        if (valid && caught != null) {
            throw caught;
        }
        DescriptorTEST.assertEquals((String)("Expected " + valid + " for new Descriptor(String[], String[]) names=" + Arrays.asList(names) + " values=" + Arrays.asList(values)), (boolean)valid, (boolean)descriptorValid);
        caught = null;
        descriptorValid = false;
        try {
            descriptor = new DescriptorSupport();
            descriptor.setFields(names, values);
            descriptorValid = descriptor.isValid();
        }
        catch (RuntimeOperationsException e) {
            caught = e;
        }
        if (valid && caught != null) {
            throw caught;
        }
        DescriptorTEST.assertEquals((String)("Expected " + valid + " for new Descriptor(String[], String[]) names=" + Arrays.asList(names) + " values=" + Arrays.asList(values)), (boolean)valid, (boolean)descriptorValid);
    }

    private void compareFieldNames(String[] one, String[] two) throws Exception {
        Set setOne = this.makeMap(one).keySet();
        ArrayList<String> setTwo = new ArrayList<String>(Arrays.asList(two));
        for (Object key : setOne) {
            if (setTwo.remove(key)) continue;
            DescriptorTEST.fail((String)("Expected " + Arrays.asList(two) + " to contain field " + key));
        }
        DescriptorTEST.assertTrue((String)("Didn't expect the following fields " + setTwo), (boolean)setTwo.isEmpty());
    }

    private void compareFieldValuesUnsorted(Object[] one, Object[] two) throws Exception {
        if (one.length != two.length) {
            DescriptorTEST.fail((String)("Lengths are different original=" + Arrays.asList(one) + " result=" + Arrays.asList(two)));
        }
        List<Object> listOne = Arrays.asList(one);
        ArrayList<Object> listTwo = new ArrayList<Object>(Arrays.asList(two));
        for (Object value : listOne) {
            if (listTwo.remove(value)) continue;
            DescriptorTEST.fail((String)("Expected " + two + " to contain " + value));
        }
        DescriptorTEST.assertTrue((String)("Didn't expect the following fields " + listTwo), (boolean)listTwo.isEmpty());
    }

    private void compareFieldValues(Object[] one, Object[] two) throws Exception {
        if (one.length != two.length) {
            DescriptorTEST.fail((String)("Lengths are different original=" + Arrays.asList(one) + " result=" + Arrays.asList(two)));
        }
        for (int i = 0; i < one.length; ++i) {
            if (one[i] == null && two[i] != null) {
                DescriptorTEST.fail((String)("For index " + i + " original=" + one[i] + " result=" + two[i]));
                continue;
            }
            if (one[i] != null && two[i] == null) {
                DescriptorTEST.fail((String)("For index " + i + " original=" + one[i] + " result=" + two[i]));
                continue;
            }
            if (one[i] == null || one[i].equals(two[i])) continue;
            DescriptorTEST.fail((String)("For index " + i + " original=" + one[i] + " result=" + two[i]));
        }
    }

    private void compareFields(String[] one, String[] two) throws Exception {
        Map mapOne = this.makeMap(one);
        Map mapTwo = this.makeMap(two);
        for (Map.Entry entry : mapOne.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value.equals(mapTwo.remove(key))) continue;
            DescriptorTEST.fail((String)("Expected " + Arrays.asList(two) + " to contain field " + key));
        }
        DescriptorTEST.assertTrue((String)("Didn't expect the following fields " + mapTwo), (boolean)mapTwo.isEmpty());
    }

    private Map makeMap(String[] fields) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            int index = fields[i].indexOf("=");
            String key = fields[i].substring(0, index);
            String value = null;
            if (index != fields[i].length() - 1) {
                value = fields[i].substring(index);
            }
            result.put(key, value);
        }
        return result;
    }
}

