/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.javaee;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.jpa.javaee.JavaEEModuleInformer;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

public class SimpleJavaEEModuleInformer
implements JavaEEModuleInformer {
    public String getApplicationName(DeploymentUnit unit) {
        DeploymentUnit topLevel = unit.getTopLevel();
        if (topLevel.isAttachmentPresent(JBossAppMetaData.class)) {
            return topLevel.getSimpleName();
        }
        return null;
    }

    public String getModulePath(DeploymentUnit unit) {
        return unit.getRelativePath();
    }

    public JavaEEModuleInformer.ModuleType getModuleType(DeploymentUnit unit) {
        if (unit.isAttachmentPresent(JBossClientMetaData.class)) {
            return JavaEEModuleInformer.ModuleType.APP_CLIENT;
        }
        if (unit.isAttachmentPresent(JBossMetaData.class) && this.isReallyAnEjbDeployment(unit)) {
            return JavaEEModuleInformer.ModuleType.EJB;
        }
        if (unit.isAttachmentPresent(JBossWebMetaData.class)) {
            return JavaEEModuleInformer.ModuleType.WEB;
        }
        return JavaEEModuleInformer.ModuleType.JAVA;
    }

    private boolean isReallyAnEjbDeployment(DeploymentUnit unit) {
        JBossMetaData metaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        if (metaData.getEnterpriseBeans() == null || metaData.getEnterpriseBeans().size() == 0) {
            return false;
        }
        for (JBossEnterpriseBeanMetaData bean : metaData.getEnterpriseBeans()) {
            if (bean instanceof JBossEntityBeanMetaData) continue;
            return true;
        }
        return false;
    }
}

