/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.protocol.servlet.ServletProtocolConfiguration;
import org.jboss.arquillian.protocol.servlet.ServletUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletURIHandler {
    private ServletProtocolConfiguration config;
    private Collection<HTTPContext> contexts;

    public ServletURIHandler(ServletProtocolConfiguration config, Collection<HTTPContext> contexts) {
        if (config == null) {
            throw new IllegalArgumentException("ServletProtocolConfiguration must be specified");
        }
        if (contexts == null || contexts.size() == 0) {
            throw new IllegalArgumentException("HTTPContext must be specified");
        }
        this.config = config;
        this.contexts = contexts;
    }

    public URI locateTestServlet(Method method) {
        HTTPContext context = this.locateHTTPContext(method);
        return ServletUtil.determineBaseURI(this.config, context, "ArquillianServletRunner");
    }

    private HTTPContext locateHTTPContext(Method method) {
        TargetsContainer targetContainer = method.getAnnotation(TargetsContainer.class);
        if (targetContainer != null) {
            String targetName = targetContainer.value();
            for (HTTPContext context : this.contexts) {
                if (!targetName.equals(context.getName())) continue;
                return context;
            }
            throw new IllegalArgumentException("Could not determin HTTPContext from ProtocolMetadata for target: " + targetName + ". Verify that the given target name in @" + TargetsContainer.class.getSimpleName() + " match a name returned by the deployment container");
        }
        return this.contexts.toArray(new HTTPContext[0])[0];
    }
}

