/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.ee.embedded_1_1.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServletContext
implements ServletContext {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> initParameters = new HashMap<String, String>();
    private final Map<String, String> mimeTypes = new HashMap<String, String>();
    private File webappRoot = null;

    public MockServletContext(String path) {
        if (path != null) {
            this.webappRoot = new File(path);
            if (!this.webappRoot.exists() || !this.webappRoot.isDirectory()) {
                this.webappRoot = null;
            }
        }
        File file = new File("target/work/");
        file.mkdirs();
        this.attributes.put("javax.servlet.context.tempdir", file);
        this.mimeTypes.put("html", "text/html");
        this.mimeTypes.put("htm", "text/html");
        this.mimeTypes.put("css", "text/css");
        this.mimeTypes.put("xml", "text/xml");
        this.mimeTypes.put("js", "text/plain");
        this.mimeTypes.put("gif", "image/gif");
        this.mimeTypes.put("jpg", "image/jpeg");
        this.mimeTypes.put("png", "image/png");
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public void addMimeType(String fileExtension, String mimeType) {
        this.mimeTypes.put(fileExtension, mimeType);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public ServletContext getContext(String name) {
        return this;
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1 || index == name.length() - 1) {
            return null;
        }
        return this.mimeTypes.get(name.substring(index + 1));
    }

    public int getMinorVersion() {
        return 3;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.getRequestDispatcher(name);
    }

    public String getRealPath(String name) {
        File f;
        if (this.webappRoot == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(f = new File(this.webappRoot, name)).exists()) {
            return null;
        }
        return f.getPath();
    }

    public RequestDispatcher getRequestDispatcher(final String name) {
        return new RequestDispatcher(){

            public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
                servletResponse.getWriter().write("FORWARD TO RESOURCE: " + name);
            }

            public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
                servletResponse.getWriter().write("INCLUDE OF RESOURCE: " + name);
            }
        };
    }

    public URL getResource(String name) throws MalformedURLException {
        File f;
        if (this.webappRoot == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(f = new File(this.webappRoot, name)).exists()) {
            return null;
        }
        return f.toURI().toURL();
    }

    public InputStream getResourceAsStream(String name) {
        File f;
        if (this.webappRoot == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(f = new File(this.webappRoot, name)).exists()) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<String> getResourcePaths(String name) {
        int f;
        if (this.webappRoot == null) {
            return new HashSet<String>();
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String[] elements = null;
        elements = name.trim().length() == 0 ? new String[]{} : name.split("/");
        File current = this.webappRoot;
        for (int i = 0; i < elements.length; ++i) {
            File[] files = current.listFiles();
            boolean match = false;
            for (f = 0; f < files.length; ++f) {
                if (!files[f].getName().equals(elements[i]) || !files[f].isDirectory()) continue;
                current = files[f];
                match = true;
                break;
            }
            if (match) continue;
            return null;
        }
        File[] files = current.listFiles();
        HashSet<String> result = new HashSet<String>();
        int stripLength = this.webappRoot.getPath().length();
        for (f = 0; f < files.length; ++f) {
            String s = files[f].getPath().substring(stripLength).replace('\\', '/');
            if (files[f].isDirectory()) {
                s = s + "/";
            }
            result.add(s);
        }
        return result;
    }

    public String getServerInfo() {
        return "Wicket Mock Test Environment v1.0";
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public String getServletContextName() {
        return "Mock";
    }

    public Enumeration<String> getServletNames() {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return null;
    }

    public void log(Exception e, String msg) {
    }

    public void log(String msg) {
    }

    public void log(String msg, Throwable cause) {
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public String getContextPath() {
        return "";
    }

    public FilterRegistration.Dynamic addFilter(String arg0, String arg1) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String arg0, Filter arg1) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String arg0, Class<? extends Filter> arg1) {
        return null;
    }

    public void addListener(String arg0) {
    }

    public <T extends EventListener> void addListener(T arg0) {
    }

    public void addListener(Class<? extends EventListener> arg0) {
    }

    public ServletRegistration.Dynamic addServlet(String arg0, String arg1) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Servlet arg1) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Class<? extends Servlet> arg1) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> arg0) throws ServletException {
        return null;
    }

    public <T extends EventListener> T createListener(Class<T> arg0) throws ServletException {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> arg0) throws ServletException {
        return null;
    }

    public void declareRoles(String ... arg0) {
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public int getEffectiveMajorVersion() {
        return 0;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public FilterRegistration getFilterRegistration(String arg0) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ServletRegistration getServletRegistration(String arg0) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public boolean setInitParameter(String arg0, String arg1) {
        return false;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> arg0) {
    }
}

