/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import org.javers.common.validation.Validate;
import org.javers.repository.sql.DialectName;
import org.javers.repository.sql.session.KeyGeneratorDefinition;
import org.javers.repository.sql.session.Parameter;
import org.javers.repository.sql.session.SelectBuilder;

abstract class Dialect {
    private final DialectName dialectName;

    Dialect(DialectName dialectName) {
        Validate.argumentIsNotNull((Object)((Object)dialectName));
        this.dialectName = dialectName;
    }

    boolean supportsSequences() {
        return this.getKeyGeneratorDefinition() instanceof KeyGeneratorDefinition.SequenceDefinition;
    }

    abstract <T extends KeyGeneratorDefinition> T getKeyGeneratorDefinition();

    DialectName getName() {
        return this.dialectName;
    }

    void limit(SelectBuilder query, long limit, long offset) {
        query.append("LIMIT ? OFFSET ?", Parameter.longParam(limit), Parameter.longParam(offset));
    }
}

