/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_aae18f4.core.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class Java9Support {
    public static final int V1_9 = 53;

    private Java9Support() {
    }

    public static byte[] readFully(InputStream is) throws IOException {
        int r;
        if (is == null) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((r = is.read(buf)) != -1) {
            out.write(buf, 0, r);
        }
        return out.toByteArray();
    }

    private static void putShort(byte[] b, int index, int s) {
        b[index] = (byte)(s >>> 8);
        b[index + 1] = (byte)s;
    }

    private static short readShort(byte[] b, int index) {
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    public static boolean isPatchRequired(byte[] buffer) {
        return Java9Support.readShort(buffer, 6) == 53;
    }

    public static byte[] downgradeIfRequired(byte[] buffer) {
        return Java9Support.isPatchRequired(buffer) ? Java9Support.downgrade(buffer) : buffer;
    }

    public static byte[] downgrade(byte[] b) {
        byte[] result = new byte[b.length];
        System.arraycopy(b, 0, result, 0, b.length);
        Java9Support.putShort(result, 6, 52);
        return result;
    }

    public static void upgrade(byte[] b) {
        Java9Support.putShort(b, 6, 53);
    }
}

