/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.function.UnaryOperator;
import javax.security.auth.x500.X500Principal;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.security.ServerSecurityRealm;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.AggregateSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

public class AggregateRealmConfiguration
extends ConfigurationElement<AggregateRealmConfiguration>
implements RealmProvider {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, (Object)"aggregate", String.class).immutable().build();
    static final AttributeDefinition<String> AUTHN_REALM = AttributeDefinition.builder((Enum)Attribute.AUTHENTICATION_REALM, null, String.class).immutable().build();
    static final AttributeDefinition<List<String>> AUTHZ_REALMS = AttributeDefinition.builder((Enum)Attribute.AUTHORIZATION_REALMS, null, List.class).initializer(ArrayList::new).immutable().build();
    static final AttributeDefinition<NameRewriter> NAME_REWRITER = AttributeDefinition.builder((Enum)Element.NAME_REWRITER, (Object)NameRewriter.IDENTITY_REWRITER, NameRewriter.class).autoPersist(false).immutable().build();
    private EnumSet<ServerSecurityRealm.Feature> authenticationFeatures;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AggregateRealmConfiguration.class, new AttributeDefinition[]{NAME, AUTHN_REALM, AUTHZ_REALMS, NAME_REWRITER});
    }

    AggregateRealmConfiguration(AttributeSet attributes) {
        super((Enum)Element.AGGREGATE_REALM, attributes, new ConfigurationElement[0]);
    }

    @Override
    public SecurityRealm build(SecurityConfiguration securityConfiguration, RealmConfiguration realm, SecurityDomain.Builder domainBuilder, Properties properties) {
        SecurityRealm[] authzRealms;
        domainBuilder.setDefaultRealmName(this.name());
        String authenticationRealm = this.authenticationRealm();
        SecurityRealm authnRealm = realm.realms.get(authenticationRealm);
        if (authnRealm == null) {
            throw Server.log.unknownRealm(authenticationRealm);
        }
        this.authenticationFeatures = EnumSet.noneOf(ServerSecurityRealm.Feature.class);
        for (RealmProvider provider : realm.realmProviders()) {
            if (!provider.name().equals(authenticationRealm)) continue;
            provider.applyFeatures(this.authenticationFeatures);
        }
        List<String> names = this.authorizationRealms();
        if (names.isEmpty()) {
            authzRealms = (SecurityRealm[])realm.realms.values().toArray(SecurityRealm[]::new);
        } else {
            authzRealms = new SecurityRealm[names.size()];
            for (int i = 0; i < names.size(); ++i) {
                SecurityRealm securityRealm = realm.realms.get(names.get(i));
                if (securityRealm == null) {
                    throw Server.log.unknownRealm(names.get(i));
                }
                authzRealms[i] = securityRealm;
            }
        }
        return new AggregateSecurityRealm(authnRealm, AggregateRealmConfiguration.asPrincipalRewriter(this.nameRewriter()), authzRealms);
    }

    @Override
    public void applyFeatures(EnumSet<ServerSecurityRealm.Feature> features) {
        features.retainAll(EnumSet.of(ServerSecurityRealm.Feature.ENCRYPT));
        features.addAll(this.authenticationFeatures);
    }

    static UnaryOperator<Principal> asPrincipalRewriter(NameRewriter rewriter) {
        return principal -> {
            if (principal == null) {
                return null;
            }
            if (principal instanceof NamePrincipal || principal instanceof X500Principal) {
                String rewritten = rewriter.rewriteName(principal.getName());
                return rewritten == null ? null : new NamePrincipal(rewritten);
            }
            return principal;
        };
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public String authenticationRealm() {
        return (String)this.attributes.attribute(AUTHN_REALM).get();
    }

    public List<String> authorizationRealms() {
        return (List)this.attributes.attribute(AUTHZ_REALMS).get();
    }

    public NameRewriter nameRewriter() {
        return (NameRewriter)this.attributes.attribute(NAME_REWRITER).get();
    }
}

