/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import java.util.Collections;
import org.infinispan.rest.ALPNHandler;
import org.infinispan.rest.RestRequestHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;

public class RestChannelInitializer
extends NettyChannelInitializer<RestServerConfiguration> {
    static final int MAX_INITIAL_LINE_SIZE = 4096;
    static final int MAX_HEADER_SIZE = 8192;
    private final RestServer restServer;

    public RestChannelInitializer(RestServer restServer, NettyTransport transport) {
        super((ProtocolServer)restServer, transport, null, null, RestChannelInitializer.getAlpnConfiguration(restServer));
        this.restServer = restServer;
    }

    public void initializeChannel(Channel ch) throws Exception {
        super.initializeChannel(ch);
        if (((RestServerConfiguration)this.server.getConfiguration()).ssl().enabled()) {
            ch.pipeline().addLast(new ChannelHandler[]{new ALPNHandler(this.restServer)});
        } else {
            ALPNHandler.configurePipeline(ch.pipeline(), "http/1.1", this.restServer, Collections.emptyMap());
        }
    }

    private static ApplicationProtocolConfig getAlpnConfiguration(RestServer restServer) {
        if (((RestServerConfiguration)restServer.getConfiguration()).ssl().enabled()) {
            return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"});
        }
        return null;
    }

    public ChannelHandler getRestHandler() {
        return new RestRequestHandler(this.restServer);
    }
}

