/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.strong;

import java.util.concurrent.CompletionException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.counter.impl.strong.AbstractStrongCounter;
import org.infinispan.counter.impl.strong.StrongCounterKey;

public class BoundedStrongCounter
extends AbstractStrongCounter {
    private static final Log log = (Log)LogFactory.getLog(BoundedStrongCounter.class, Log.class);

    public BoundedStrongCounter(String counterName, AdvancedCache<StrongCounterKey, CounterValue> cache, CounterConfiguration configuration, CounterManagerNotificationManager notificationManager) {
        super(counterName, cache, configuration, notificationManager);
    }

    @Override
    protected long handleAddResult(CounterValue counterValue) {
        this.throwOutOfBoundExceptionIfNeeded(counterValue.getState());
        return counterValue.getValue();
    }

    @Override
    protected Long handleSetResult(Object state) {
        if (state instanceof CounterState) {
            this.throwOutOfBoundExceptionIfNeeded((CounterState)state);
        }
        assert (state instanceof Long);
        return (Long)state;
    }

    @Override
    protected Long handleCASResult(Object state) {
        if (state instanceof CounterState) {
            this.throwOutOfBoundExceptionIfNeeded((CounterState)state);
        }
        assert (state instanceof Long);
        return (Long)state;
    }

    private void throwOutOfBoundExceptionIfNeeded(CounterState state) {
        switch (state) {
            case LOWER_BOUND_REACHED: {
                throw new CompletionException((Throwable)log.counterOurOfBounds("Lower bound"));
            }
            case UPPER_BOUND_REACHED: {
                throw new CompletionException((Throwable)log.counterOurOfBounds("Upper bound"));
            }
        }
    }

    public String toString() {
        return "BoundedStrongCounter{counterName=" + String.valueOf(this.key.getCounterName()) + "}";
    }
}

